<?php
ini_set('display_errors', 0);
defined('BASEPATH') OR exit('No direct script access allowed');

class Voucher_model extends CI_Model {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('voucher_model');
	}

	public function get_cadet_invoice($branch, $promotion_id) {
	   
	    //echo $promotion_id;exit;
	    
	    $q = $this->db->select('student.student_name as cadet_name,student.father_name,class.class_name,section.section_name,invoice.fee_pack,invoice.date_expire,invoice.status,invoice.id,invoice.date as due_date,invoice.date_expire,promotion.id as p_id');
	    $this->db->from('student');
	    $this->db->join('promotion','promotion.student_id=student.id');   
	    $this->db->join('invoice', 'invoice.student_id=promotion.id');
	    $this->db->join('class', 'promotion.class_id=class.class_id');
	    $this->db->join('section', 'promotion.section_id=section.section_id')->where_in('invoice.student_id', $promotion_id)->order_by('invoice.id', 'DESC');
        //echo "<pre>";print_r($q->get()->result_array());exit;
	    return $r = $q->get()->result_array();
	}
	
	public function invoiceViewArrayAgainstFeeHeads($pro_id){
        $pro_array=$this->getPromotionArray($pro_id);
        $fee_heads_array=$this->db->select('distinct(fee_id) as `fee_id`')->where_in('pro_id',$pro_array)->get('fee_accounts')->result_array();
        $fee_heads_array=array_column($fee_heads_array,'fee_id');
        $fee_head_details=array();
        foreach ($fee_heads_array as $key => $value) {
            $fee_head_details[$key]['fee_id']=$value;
            $fee_head_details[$key]['name']=$this->getFeeName($value);
            $fee_head_details[$key]['balance']=$this->getFeeBalance($pro_id,$value);
        }
        return $fee_head_details;
    }
    public function countTotalFee($id=0)
    {
        $total = 0;
        if($id!=0)
        {
            $pro_id=$this->getProIdFromInvoice($id);
            $fee_heads=$this->invoiceViewArrayAgainstFeeHeads($pro_id);
            foreach ($fee_heads as $key => $value) {
                $total+=$value['balance'];
            }
            return $total;
        }
    }

 public function countTotalFee_WithoutArears_WithoutOtherFee($id=0)
    {
        $total = 0;
        if($id!=0)
        {
            $d = $this->db->select("invoice.student_id,invoice.fee_pack,invoice.late_fine,invoice.admin_fee,invoice.is_admitted,invoice.status,invoice.date_expire")->from("invoice")->where("invoice.is_delete","0")->where("invoice.id",$id)->get()->row();
            $total += $d->fee_pack;
            if(date("Y-m-d",strtotime($d->date_expire))<=date("Y-m-d") && $d->status==0)
            {
                $total = $total + (($total * $d->late_fine) / 100);;
            }
            if($d->is_admitted==1)
            {
                $total += $d->admin_fee;
            }
            return $total;
        }
    }
    
 public function getBadDebtorsAmount()
    {   
        $bad_debtors_amount=0;
        $BadDebtors=$this->getBadDebtors();
        //var_dump('<pre>',$BadDebtors);die;
        foreach ($BadDebtors as $selectedBadDebtors) {   
                $bad_debtors_amount+=$this->getRemainingAmount($selectedBadDebtors['vouchers']['id']);
        }
        return ceil($bad_debtors_amount);
    }
    
 public function getRemainingAmount($id='')
    {   
        $voucher=$this->db->where('id',$id)->where('is_delete',0)->get('invoice')->row_array();
        if($voucher){
        	if($voucher['status']==1)
        	    return $voucher['remaining'];
        	else{
        	    return $this->countTotalFee($id);
        	}
        }
    }
    
    //===============================other fee calculations==================================

public function total_other_fee($invoice_id=0)
    {
        $this->db->select("*");
        $this->db->from("fee_installment");
        $this->db->where("invoice",$invoice_id);
        $this->db->where("is_delete",0);
        $other_fee=$this->db->get()->result_array();
        $total_other_fee=0;
        //var_dump($other_fee);
            if(!empty($other_fee))
            {
                foreach ($other_fee as $key => $value) {
                    $total_other_fee+=$value['amount'];
                }
                return $total_other_fee;
            }
            else
            {
                return 0;
            }
    }
    
     public function getArrearsAmount($id=0,$std_id=0)
    {
        $total=0;
        $lastv = $this->db->query("SELECT `id`,`student_id`,`is_admitted`,`admin_fee`,`status`,`advance`,`remaining`,`late_fine`,`fee_pack` FROM  `invoice` WHERE `id` <>  '$id' AND  `student_id` =  '".$std_id."' AND  `id` <  '".$id."' AND is_delete='0'  ORDER BY  `id` DESC ")->row();
        if($lastv)
        {
            if($lastv->status==1)
            {
                $data['lastadv'] = $lastv->advance;
                $data['lastrem'] = $lastv->remaining;
            }else{
                $lastv_items = $this->db->select("sum(amount) as sum")->from("fee_installment")->where("invoice",$lastv->id)->where("is_delete","0")->get()->row();
                $calc_total = $lastv->fee_pack + $lastv_items->sum;
                $calc = $calc_total + (($calc_total * $lastv->late_fine) / 100);
                if($lastv->is_admitted==1) {
                    $calc+=$lastv->admin_fee;
                }
                $data['lastadv'] = 0;
                $data['lastrem'] = $calc;
            }
        $total -= $data['lastadv'];
        $total += $data['lastrem'];
        }
        return $total;
    }
    
 public function getBadDebtors()
    {
       $this->db->select('promotion.id as promotion_id,student.id as student_id,student.student_name,student.status');
       $this->db->join('promotion','promotion.student_id=student.id');
       $this->db->where('student.status!=',0);
       $this->db->where('student.branch',$this->user_model->getBranch());
       $non_active_students= $this->db->get('student')->result_array();

       foreach ($non_active_students as $key=> $selected_student) {
           $this->db->select('*');
           $this->db->where('student_id',$selected_student['promotion_id']);
           $this->db->where('is_delete',0);
           $this->db->order_by('id','DESC');
           $non_active_students[$key]['vouchers']=$this->db->get('invoice')->row_array();
       }

    //if u want to revert back to old query delele order_by clause and change row_array to result_array from above query

       foreach ($non_active_students as $key => $selected_student) {
           if(empty($selected_student['vouchers']))
                unset($non_active_students[$key]);
           if($this->getRemainingAmount($selected_student['vouchers']['id'])<=0)
           	unset($non_active_students[$key]);
       }

       /*foreach ($non_active_students as $key => $selected_student) {
           $total_vouchers_of_selected_student=count($selected_student['vouchers']);
           $start_deleteting=false;
           for ($i=$total_vouchers_of_selected_student-1; $i>=0 ; $i--) {
               if($selected_student['vouchers'][$i]['status']==1)
               $start_deleteting=true;
               if($start_deleteting==true)
               unset($selected_student['vouchers'][$i]);
           }
       }*/

       return $non_active_students; 

    }

       
    public function countArrears($id=0,$std_id=0,$total=0)
    {
        $lastv = $this->db->query("SELECT `id`,`status`,`advance`,`remaining`,`late_fine`,`fee_pack`,`is_transport_taken`,`transport_fee` FROM  `invoice` WHERE  `student_id` =  '".$std_id."' AND  `id` <  '".$id."' AND is_delete='0'  ORDER BY  `id` DESC ")->result_array();
        $data['lastadv'] = 0;
	    $data['lastrem'] = 0;
        if($lastv && $lastv[0]['status']==1)
        {
		$data['lastadv'] = $lastv[0]['advance'];
		$data['lastrem'] = $lastv[0]['remaining'];
		
		$total -= $data['lastadv'];
		$total += $data['lastrem'];
        }
        
        elseif($lastv && $lastv[0]['status']==0)
        {
	    $i=0;
	    while(isset($lastv[$i]['status']) && $lastv[$i]['status']!=1) {
	    	//var_dump($lastv[$i]['id']);
	                $lastv_items = $this->db->select("sum(amount) as sum")->from("fee_installment")->where("invoice",$lastv[$i]['id'])->where("is_delete","0")->get()->row();
	                $calc_total = $lastv[$i]['fee_pack'] + $lastv_items->sum;
	                //$calc = $calc_total + (($calc_total * $lastv[$i]['late_fine']) / 100);
	                $calc = $calc_total;
	                if($lastv[$i]['is_transport_taken']==1) {
	                	$calc+=$lastv[$i]['transport_fee'];
	                }
	                $data['lastadv'] = 0;
	                $data['lastrem'] += $calc;
		        $total -= $data['lastadv'];
		        $total += $calc;
		        $i++;
		        //var_dump($total);
		        //var_dump($data['lastrem']);
	        }
	        //var_dump("hello");
	        //die();
	        //last paid voucher
	    if(isset($lastv[$i]['status']) && $lastv[$i]['status']==1){
	    		//var_dump($lastv[$i]['status']);die();
		    	$data['lastadv'] = $lastv[$i]['advance'];
			$data['lastrem'] = $lastv[$i]['remaining'];
			
			$total -= $data['lastadv'];
			$total += $data['lastrem'];
		}
		 //var_dump($total);die();
		 //end last paid voucher
	        //echo "end while";die();
        }
        return $total;
    }


//============================calculate expected fee for given month=======================================

    public function ExpectedFeeMonth($month='')
    {
        if($month=='')
        $month=date('Y-m');

        $this->db->select('id,student_id,fee_pack,date');
        $this->db->where('is_delete',0)->where('left(date,7)',$month)->where('branch_id',$this->user_model->getBranch());
        $thisMonthVouchers=$this->db->get('invoice')->result_array();
        $expected_fee=0;
        foreach ($thisMonthVouchers as $key => $selectedVoucher) {
            $expected_fee+=$this->countTotalFee($selectedVoucher['id']);
        }
        return $expected_fee;
    }
    public function ExpectedFeeMonthWithBranch($month='',$branch=0)
    {
        if($month=='')
        $month=date('Y-m');

        $this->db->select('id,student_id,fee_pack,date');
        $this->db->where('is_delete',0)->where('left(date,7)',$month);
        if($branch!=0){
            $this->db->where('branch_id',$branch);
        }
        $thisMonthVouchers=$this->db->get('invoice')->result_array();
        $expected_fee=0;
        foreach ($thisMonthVouchers as $key => $selectedVoucher) {
            $expected_fee+=$this->countTotalFee($selectedVoucher['id']);
        }
        return $expected_fee;
    }
    
    public function getPromotionArray($pro_id='')
    {
	//=================>getting all promotion id array of current voucher============================
            
        $student_id_actual=$this->db->select('student_id')->where('id',$pro_id)->get('promotion')->row_array()['student_id'];
        $promotion_id_assoc_array=$this->db->select('id')->where('student_id',$student_id_actual)->get('promotion')->result_array();
        if(!empty($promotion_id_assoc_array)) {
        	foreach ($promotion_id_assoc_array as $key => $value) {
	        $promotion_id_array[]=$value['id'];
	        }
        }
        else {
        	$promotion_id_array[]=$pro_id;
        }
        //var_dump($promotion_id_array);die();
        
        //=================>end of getting promotion id array logic============================
        return $promotion_id_array;
    }
    
     public function invoiceViewArrayAgainstFeeHeads_byinvoice_updated($pro_id,$inv)
    {
         $pro_array=$this->getPromotionArray($pro_id);
         $fee_heads_array=$this->db->select('distinct(fee_id) as `fee_id`')->where_in('pro_id',$pro_array)->get('fee_accounts')->result_array();
         $fee_heads_array=array_column($fee_heads_array,'fee_id');
         $fee_head_details=array();
        foreach ($fee_heads_array as $key => $value) {
            $fee_head_details[$key]['fee_id']=$value;
            $fee_head_details[$key]['name']=$this->getFeeName($value);
            $fee_head_details[$key]['arrears']=$this->getFeeBalance_byinvoice_arrears($pro_id,$value,$inv);
            $fee_head_details[$key]['current_balance']=$this->getFeeBalance_byinvoice_actualBalance($pro_id,$value,$inv);
            $fee_head_details[$key]['received']=$this->getFeeBalance_byinvoice_receivedBalance($pro_id,$value,$inv);
        }
       return $fee_head_details;
    }
    
     public function getFeeBalance_byinvoice($pro_id,$fee_id,$inv)
    {
        if(empty($inv))
        {
            $inv=0;
        }
        $pro_array=$this->getPromotionArray($pro_id);
      
        $balance=$this->db->select("sum(invoice_amount)-sum(paid_amount) as final_balance")
                          ->where_in('pro_id',$pro_array)
                          ->where('invoice_id<=',$inv)
                          ->where('fee_id',$fee_id)
                          ->get('fee_accounts')->row_array()['final_balance'];
       
        //$balance=$this->db->where('id',$balance)->get('fee_accounts')->row_array()['final_balance'];
        
        if($balance)
        return $balance;
        else{
            return 0;
        }
    }
    
      public function getFeeBalance_byinvoice_arrears($pro_id,$fee_id,$inv)
    {
        if(empty($inv))
        {
            $inv=0;
        }
        $pro_array=$this->getPromotionArray($pro_id);
      
        $balance=$this->db->select("sum(invoice_amount)-sum(paid_amount) as final_balance")
                          ->where_in('pro_id',$pro_array)
                          ->where('invoice_id<',$inv)
                          ->where('fee_id',$fee_id)
                          ->get('fee_accounts')->row_array()['final_balance'];
        
        if($balance)
        return $balance;
        else{
            return 0;
        }
    }
    
     public function getFeeBalance_byinvoice_actualBalance($pro_id,$fee_id,$inv)
    {
        if(empty($inv))
        {
            $inv=0;
        }
        $pro_array=$this->getPromotionArray($pro_id);
      
        $balance=$this->db->select("invoice_amount as final_balance")
                          ->where_in('pro_id',$pro_array)
                          ->where('invoice_id',$inv)
                          ->where('fee_id',$fee_id)
                          ->get('fee_accounts')->row_array()['final_balance'];
        
        if($balance)
        return $balance;
        else{
            return 0;
        }
    }
    
    public function getFeeBalance_byinvoice_receivedBalance($pro_id,$fee_id,$inv)
    {
        if(empty($inv))
        {
            $inv=0;
        }
        $pro_array=$this->getPromotionArray($pro_id);
      
        $balance=$this->db->select("paid_amount as final_balance")
                          ->where_in('pro_id',$pro_array)
                          ->where('invoice_id',$inv)
                          ->where('fee_id',$fee_id)
                          ->get('fee_accounts')->row_array()['final_balance'];
        
        if($balance)
        return $balance;
        else{
            return 0;
        }
    }
    

   public function getFeeBalance($pro_id,$fee_id)
    {
        
         $pro_array=$this->getPromotionArray($pro_id);
      
        $balance=$this->db->select("max(id) as id")->where_in('pro_id',$pro_array)->where('fee_id',$fee_id)->get('fee_accounts')->row_array()['id'];
        
        $balance=$this->db->where('id',$balance)->get('fee_accounts')->row_array()['final_balance'];
        
        if($balance)
        return $balance;
        else{
            return 0;
        }
        
    }  
    
    public function updateFeeBalance($fee_id,$pro_id,$inv_id,$amount)
    {
        $pro_array=$this->getPromotionArray($pro_id);
        $balance=$this->db->where_in('pro_id',$pro_array)->where('fee_id',$fee_id)->order_by('id','DESC')->limit(1)->get('fee_accounts')->row_array()['balance'];
        $data=array(
                    'fee_id'=>$fee_id,
                    'pro_id'=>$pro_id,
                    'invoice_id'=>$inv_id,
                    'invoice_amount'=>$amount,
                    'date'=>date('Y-m-d')
                );
        if($balance) {
            $new_balance=$balance+$amount;
            $data['balance']=$new_balance;
            $res=$this->db->insert('fee_accounts',$data);
            if($res)
            return true;
        }
        else{
            $data['balance']=$amount;
            $res=$this->db->insert('fee_accounts',$data);
            if($res)
            return true;
        }
        return false;
    }

    public function getFeeName($fee_id='')
    {
        if($fee_id!='') {
            if($fee_id=='-1')
            return "Tuition fee";
            elseif($fee_id=='-2')
            return "Admission fee";
            elseif($fee_id=='-3')
            return "Transport fee";
            elseif($fee_id=='-4')
            return "Arrear fee";
            elseif($fee_id=='-7')
            return "Late Fine";
            else
            return @$this->db->where('id',$fee_id)->get('fee_def')->row_array()['name'];
        }
    }


    public function updateFeePaid($fee_id,$pro_id,$amount)
    {
        $balance=$this->getFeeBalance($pro_id,$fee_id);
        $new_balance=$balance-$amount;
        $data=array(
                    'fee_id'=>$fee_id,
                    'pro_id'=>$pro_id,
                    'paid_amount'=>$amount,
                    'date'=>date('Y-m-d'),
                    'balance'=>$new_balance
                );
        $this->db->insert('fee_accounts',$data);
    }

    public function getProIdFromInvoice($inv_id)
    {
        if($inv_id!='') {
            return @$this->db->where('id',$inv_id)->get('invoice')->row_array()['student_id'];
        }
    }

    public function getLastVoucher($pro_id)
    {
       return @$this->db->where('student_id',$pro_id)->where('is_delete',0)->order_by('id','DESC')->limit(1)->get('invoice')->row_array()['id'];
    }
     public function invoiceViewArrayAgainstFeeHeads_byinvoice($pro_id,$inv)
    {
         $pro_array=$this->getPromotionArray($pro_id);
         $fee_heads_array=$this->db->select('distinct(fee_id) as `fee_id`')->where_in('pro_id',$pro_array)->get('fee_accounts')->result_array();
         $fee_heads_array=array_column($fee_heads_array,'fee_id');
         $fee_head_details=array();
        foreach ($fee_heads_array as $key => $value) {
            $fee_head_details[$key]['fee_id']=$value;
            $fee_head_details[$key]['name']=$this->getFeeName($value);
            $fee_head_details[$key]['final_balance']=$this->getFeeBalance_byinvoice($pro_id,$value,$inv);
        }
       return $fee_head_details;
    }

      
      public function getVoucherContactNumber($id='')
    {
        if($id!='') {
            return $this->db->select('student.id,student.student_name,student.father_contact,class.class_name')->join('promotion','invoice.student_id=promotion.id')->join('student','student.id=promotion.student_id')
            ->join('class','class.class_id=promotion.class_id')->where('invoice.id',$id)->get('invoice')->row_array();
        }
    }

}

/* End of file voucher_model.php */
/* Location: ./application/models/voucher_model.php */