<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Syllabus extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
        $this->load->model('User_model');
	}


    public function index()
    {
       
        $data['title'] = "Syllabus";  
        $student_id = $this->User_model->userInfo()['student_id'];
        $user_img=@$this->db->select('img')
	                              ->from('student')
	                              ->where('id',$student_id)
	                              ->get()->row_array();
	   //echo "<pre>";print_r($user_img);exit;
	   $data['user_img']=$user_img;
        $is_active_class=$this->db->select('p.class_id,c.class_name')
                               ->from('promotion p')
                               ->order_by('p.id','DESC')
                               ->where('p.is_active',1)
                               ->join('class c', 'c.class_id = p.class_id', 'lef')
                               ->where('p.student_id',$student_id)
                               ->get()->row_array();
        $student_class_id = $is_active_class["class_id"];
        $data['class'] = $is_active_class["class_name"];
        $query=$this->db->select('*')
                               ->from('syllabus')
                               ->order_by('id','DESC')
                               ->where('is_delete',0)
                               ->where('class',$student_class_id)
                               -> get();
        $data['table']=$query->result_array();
        $data['userInfo'] =  $this->User_model->userInfo();
        $student_id = $data['userInfo']['student_id'];
	   if (empty($data['table'])) {
            $this->session->set_flashdata('msg', 'No data avaliable');
       }
        $data['main'] = "syllabus/syllabusview";
        $this->load->view('includes/main', $data);
        
    }
    
    public function question($id)
    {
        $data['userInfo'] =  $this->User_model->userInfo("first_name,last_name,username,student_id");
		$data['base_url'] = base_url();
		$data['lec_id']=$id;
		$data['user_id']= $this->User_model->userInfo()['id'];
                                   
        $data['records']=$this->db->select('query_board.description,query_board.insert_log,admin.first_name')
                                  ->from('query_board')
                                  ->join('admin','admin.id=query_board.user_id')
                                  ->where('lec_id',$id)
                                  ->get()->result_array();
      
        $data['userInfo'] =  $this->User_model->userInfo();
       
        $data['main'] = "syllabus/query_board";
        $this->load->view('includes/main', $data);
        
    }

    public function save_query()
    {
        $query=trim($_POST['query']);
        $user_id=$_POST['user_id'];
        $lec_id=$_POST['lec_id'];
        
        $data=array(
            'lec_id'=>$lec_id,
            'user_id'=>$user_id,
            'description'=>$query
            );
        $this->db->insert('query_board',$data);
        echo "true";
        
    }
    
    public function view_lecture($id)
    {
     
        $data['records']=$this->db->select('*')
                                   ->from('video_lecture')
                                   ->where('id',$id)
                                   ->get()->row_array();

        //calling views
        $data['main'] = "syllabus/single_video_lecture";
        $this->load->view('includes/main', $data);
    }
    
    public function update_status()
    {
        $id=$_POST['lec_id'];
        $student_id = $this->User_model->userInfo()['student_id'];
        
        $is_active_id=$this->db->select('p.id')
                               ->from('promotion p')
                               ->where('p.is_active',1)
                               ->where('p.student_id',$student_id)
                               ->get()->row_array()['id'];
        
        $autochaker=$this->db->select('id')
                             ->from('lecture_log')
                             ->where('lec_id',$id)
                             ->where('student_id',$is_active_id)
                             ->get()->row_array()['id'];
        
        if(empty($autochaker))
        {
            $data=array(
                'lec_id'=>$id,
                'student_id'=>$is_active_id
                );
            $this->db->insert('lecture_log',$data);    
        }
    }




}

/* End of file datesheet.php */
/* Location: ./application/controllers/datesheet.php */