<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Notes extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model('User_model');
	}



	public function index()
	{
	
		$data['title'] = "Study Notes";	
		$student_id = $this->User_model->userInfo()['student_id'];
		$user_img=@$this->db->select('img')
	                              ->from('student')
	                              ->where('id',$student_id)
	                              ->get()->row_array();
	   //echo "<pre>";print_r($user_img);exit;
	   $data['user_img']=$user_img;
		$is_active_class=$this->db->select('p.class_id,c.class_name')
                               ->from('promotion p')
                               ->order_by('p.id','DESC')
                               ->where('p.is_active',1)
                               ->join('class c', 'c.class_id = p.class_id', 'lef')
                               ->where('p.student_id',$student_id)
                               ->get()->row_array();
        $student_class_id = $is_active_class["class_id"];
        $data['class'] = $is_active_class["class_name"];
        $query=$this->db->select('sn.*,s.name')
                               ->from('study_notes sn')
                               ->order_by('sn.id','DESC')
                               ->where('sn.is_delete',0)
                               ->join('subject s', 's.id = sn.subject', 'lef')
                               ->where('sn.class',$student_class_id)
                               -> get();
        $data['table']=$query->result_array();
        // print_r($data['table']);
        // die();
		$data['userInfo'] = $this->User_model->userInfo("id,first_name,last_name,username");
		$data['main'] = "notes/notes";
	 	$this->load->view('includes/main', $data);

	}
	
	public function lecture()
	{
	    $data['title'] = "Lectures";	
		$student_id = $this->User_model->userInfo()['student_id'];
		
		$data['is_active_id']=$this->db->select('p.id')
                               ->from('promotion p')
                               ->where('p.is_active',1)
                               ->where('p.student_id',$student_id)
                               ->get()->row_array()['id'];
                               
		$user_img=@$this->db->select('img')
	                              ->from('student')
	                              ->where('id',$student_id)
	                              ->get()->row_array();
	   //echo "<pre>";print_r($user_img);exit;
	   $data['user_img']=$user_img;
		$is_active_class=$this->db->select('p.class_id,c.class_name')
                               ->from('promotion p')
                               ->order_by('p.id','DESC')
                               ->where('p.is_active',1)
                               ->join('class c', 'c.class_id = p.class_id', 'lef')
                               ->where('p.student_id',$student_id)
                               ->get()->row_array();
        $student_class_id = $is_active_class["class_id"];
        $data['class'] = $is_active_class["class_name"];
        $query=$this->db->select('sn.*,s.name')
                               ->from('video_lecture sn')
                               ->order_by('sn.id','DESC')
                               ->where('sn.is_delete',0)
                               ->where('sn.show_status',0)
                               ->join('subject s', 's.id = sn.subject', 'lef')
                               ->where('sn.class',$student_class_id)
                               -> get();
        $data['table']=$query->result_array();
        // print_r($data['table']);
        // die();
		$data['userInfo'] = $this->User_model->userInfo("id,first_name,last_name,username");
		$data['main'] = "notes/lecture";
	 	$this->load->view('includes/main', $data);
	}


	public function download() {

		$this->load->helper('download');
		$path =  "assets/uploads/math.pdf";
		force_download($path, NULL);
	}





}

/* End of file notes.php */
/* Location: ./application/controllers/notes.php */