<?php error_reporting(0); ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php foreach ($settings as $stng) { echo $stng->title; break; } ?></title>

  <!-- Bootstrap -->
  <link href="<?php echo base_url(); ?>assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Font Awesome -->
  <link href="<?php echo base_url(); ?>assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet">

  <style>
    body {
      background: linear-gradient(135deg, #0f419a, #143a5c);
      font-family: 'Segoe UI', sans-serif;
      margin: 0;
      padding: 0;
    }

    .login_wrapper {
      height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .login_form {
      background-color: #ffffff;
      padding: 40px 30px;
      border-radius: 10px;
      box-shadow: 0 10px 25px rgba(0, 0, 0, 0.3);
      width: 100%;
      max-width: 400px;
    }

    .login_form .logo {
      text-align: center;
      margin-bottom: 25px;
    }

    .login_form .logo img {
      width: 60px;
      border-radius: 50%;
    }

    .login_form .logo span {
      display: block;
      font-size: 22px;
      font-weight: bold;
      margin-top: 10px;
      color: #0f419a;
    }

    .login_form input.form-control {
      height: 45px;
      font-size: 16px;
      margin-bottom: 15px;
    }

    .login_form button {
      width: 100%;
      background-color: #00acac;
      color: white;
      font-weight: bold;
      border: none;
      height: 45px;
      border-radius: 5px;
      font-size: 16px;
      transition: background-color 0.3s ease;
    }

    .login_form button:hover {
      background-color: #009999;
    }

    .login_form a {
      display: block;
      text-align: right;
      margin-top: 10px;
      color: #0f419a;
      text-decoration: none;
      font-weight: bold;
    }

    .login_form a:hover {
      text-decoration: underline;
    }

    .remember-me {
      display: flex;
      align-items: center;
      margin-top: -10px;
      margin-bottom: 15px;
    }

    .remember-me input {
      margin-right: 8px;
    }

    .footer {
      text-align: center;
      font-size: 13px;
      color: #aaa;
      margin-top: 15px;
    }

    .error-message {
      background-color: #f8d7da;
      color: #721c24;
      padding: 10px 15px;
      border-radius: 5px;
      font-size: 14px;
      margin-bottom: 15px;
      border: 1px solid #f5c6cb;
    }
  </style>
</head>

<body>
  <div class="login_wrapper">
    <div class="login_form">
      <div class="logo">
        <?php foreach ($settings as $stng) { ?>
          <img src="<?php echo base_url() . $stng->icon; ?>" alt="Logo">
          <span><?php echo $stng->name; ?></span>
        <?php break; } ?>
      </div>

      <!-- Show login error message -->
      <?php if ($this->session->flashdata('login_error')): ?>
        <div class="error-message">
          <?php echo $this->session->flashdata('login_error'); ?>
        </div>
      <?php endif; ?>

      <form action="<?php echo base_url(); ?>user/login" method="post">
        <input type="text" name="username" class="form-control" placeholder="Username" required>
        <input type="password" name="password" class="form-control" placeholder="Password" required>

        <div class="remember-me">
          <input type="checkbox" name="remember_me" id="remember_me">
          <label for="remember_me">Remember me</label>
        </div>

        <button type="submit">SIGN IN</button>
        <a href="<?php echo base_url(); ?>Front/reset_pass">Forgot Password?</a>

        <div class="footer">
          <?php foreach ($settings as $stng) { echo $stng->footer; break; } ?>
        </div>
      </form>
    </div>
  </div>

  <!-- jQuery -->
  <script src="<?php echo base_url(); ?>assets/vendors/jquery/dist/jquery.min.js"></script>
</body>
</html>
