<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Hostel Model
 *
 * Handles database operations for hostel management
 */

class Hostel_model extends CI_Model {

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('Hostel_model');
    }

    // Save new hostel record
    public function save($data)
    {
        $hostel = array(
            'hostel_name' => $data['hostel_name'],
            'class'       => $data['class'],
            'section'     => $data['section'],
            'type'        => $data['type'],
            'room'        => $data['room'],
            'bed'         => $data['bed'],
            'date'        => $data['date']
        );
        return $this->db->insert('hostel', $hostel);
    }

    
// Fetch all hostels
    public function get_hostel() {
    $query = $this->db->get('hostel');
    return $query; // return query object
}


    // Fetch hostel record by ID
    public function get_by_id($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('hostel');
        return $query->row_array(); // Returns single object
    }
    
    // Update hostel record
    
    
    public function update($id, $data)
    {
        $hostel = array(
            'hostel_name' => $data['hostel_name'],
            'class'       => $data['class'],
            'section'     => $data['section'],
            'type'        => $data['type'],
            'room'        => $data['room'],
            'bed'         => $data['bed'],
            'date'        => $data['date']
        );
        return $this->db->where('id', $id)->update('hostel', $hostel);
    }

    // Delete hostel record
    public function delete($id)
    {
        return $this->db->where('id', $id)->delete('hostel');
    }
}

