<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * staff Class
 *
 * @package     edusol
 * @subpackage  Syllabus
 * @author      Atif Razzaq
 * @link        http://atifrazzaq.arteck.xyz
 */
class Syllabus extends CI_Controller {

    private $userInfo = array();

    public function __construct()
    {
        parent::__construct();
        $this->load->model("user_model");
        $this->user_model->check_login("admin");

        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
    }

     public function index()
    {
    
    }
    
    public function lecture_report_section()
    {
         $this->user_model->check_permissions("Syllabus/lecture_report_section");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/lecture_report_section',$data);
       // $this->load->view('footer',$data);
    }
    public function std_lecture_report_section()
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        
        
        $student_id =$this->user_model->userInfo('student_id')['student_id'];
        
        $branch = $this->db->query("SELECT branch FROM `student` where is_delete='0' AND id = '$student_id'")->result_array();
        $branch = $branch[0]['branch'];
        $data['branch'] = $this->db->query("SELECT id,name FROM `branch` where is_delete='0' and id = '$branch'")->result_array();
            
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;

        //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/std_lecture_report_section',$data);
       // $this->load->view('footer',$data);
    }
    
    public function cbt_report_section()
    {
         $this->user_model->check_permissions("Syllabus/cbt_report_section");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/cbt_report_section',$data);
        $this->load->view('footer',$data);
    }
    public function std_cbt_report_section()
    {

        $data['is_super'] =false;
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        $student_id =$this->user_model->userInfo('student_id')['student_id'];
        
        $branch = $this->db->query("SELECT branch FROM `student` where is_delete='0' AND id = '$student_id'")->result_array();
        $branch = $branch[0]['branch'];
        $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/std_cbt_report_section',$data);
        $this->load->view('footer',$data);
    }
    public function load_test($id)
    {
        $tests=$this->db->select('paper_history.id,name,dateofpaper')
                        ->from('paper_history')
                        ->join('subject','subject.id=paper_history.subject')
                        ->where('paper_history.class',$id)
                        ->where('is_publish',1)
                        ->where('is_delete',0)
                        ->get()->result_array();
      
      if(!empty($tests))
      {
          foreach($tests as $test)
          {
              echo "<option value='".$test['id']."'>".$test['name']." ".date('d-m-Y',strtotime($test['dateofpaper']))."</option>";
          }
      }else{
          echo "";
      }
    }
    
    public function load_students($id)
    {
        $students=$this->db->select('student.id,student.student_name')
                           ->from('test_log')
                           ->join('student','student.id=test_log.cadet_id')
                           ->where('test_id',$id)
                           ->group_by('test_log.cadet_id')
                           ->get()->result_array();
         if(!empty($students))
      {
          foreach($students as $test)
          {
              echo "<option value='".$test['id']."'>".$test['student_name']."</option>";
          }
      }else{
          echo "";
      }                   
    }
    
    public function std_load_students($id)
    {            
        $student_id =$this->user_model->userInfo('student_id')['student_id'];
        $students=$this->db->select('student.id,student.student_name')
                           ->from('test_log')
                           ->join('student','student.id=test_log.cadet_id')
                           ->where('test_id',$id)
                           ->where('student.id',$student_id)
                           ->group_by('test_log.cadet_id')
                           ->get()->result_array();
         if(!empty($students))
      {
          foreach($students as $test)
          {
              echo "<option value='".$test['id']."'>".$test['student_name']."</option>";
          }
      }else{
          echo "";
      }                   
    }
    public function load_students_section($sec='',$test='',$class=''){
      $students=$this->db->select('student.id,student.student_name')
                           ->from('test_log')
                           ->join('student','student.id=test_log.cadet_id')
                           ->join('promotion','promotion.student_id=student.id')
                           ->where('test_id',$test)
                           ->where('promotion.class_id',$class)
                           ->where('promotion.section_id',$sec)
                           ->group_by('test_log.cadet_id')
                           ->get()->result_array();
         if(!empty($students))
      {
          foreach($students as $test)
          {
              echo "<option value='".$test['id']."'>".$test['student_name']."</option>";
          }
      }else{
          echo "";
      }  
    }
    public function std_load_students_section($sec='',$test='',$class=''){
        $student_id =$this->user_model->userInfo('student_id')['student_id'];
      $students=$this->db->select('student.id,student.student_name')
                           ->from('test_log')
                           ->join('student','student.id=test_log.cadet_id')
                           ->join('promotion','promotion.student_id=student.id')
                           ->where('test_id',$test)
                           ->where('promotion.class_id',$class)
                           ->where('promotion.section_id',$sec)
                           ->where('student.id',$student_id)
                           ->group_by('test_log.cadet_id')
                           ->get()->result_array();
         if(!empty($students))
      {
          foreach($students as $test)
          {
              echo "<option value='".$test['id']."'>".$test['student_name']."</option>";
          }
      }else{
          echo "";
      }  
    }
    public function load_test_today($id)
    {
        $date=date('Y-m-d');
        $tests=$this->db->select('paper_history.id,name,dateofpaper')
                        ->from('paper_history')
                        ->join('subject','subject.id=paper_history.subject')
                        ->where('paper_history.class',$id)
                        ->where('paper_history.dateofpaper',$date)
                        ->where('is_publish',1)
                        ->where('is_delete',0)
                        ->get()->result_array();
      
      if(!empty($tests))
      {
          foreach($tests as $test)
          {
              echo "<option value='".$test['id']."'>".$test['name']." ".date('d-m-Y',strtotime($test['dateofpaper']))."</option>";
          }
      }else{
          echo "";
      }
    }
    
    public function lecture_report()
    {
        $this->user_model->check_permissions("Syllabus/lecture_report");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/lecture_report_selection',$data);
        $this->load->view('footer',$data);
        
        // $this->user_model->check_permissions("Syllabus/lecture_report");

        // $data['menu'] = $this->load_model->menu();
        // $branch=$this->user_model->getbranch();
        
        // $data['classes']=$this->db->select('*')
        //                   ->from('class')
        //                   ->where('branch',$branch)
        //                   ->where('is_delete',0)
        //                   ->get()->result_array();
                          
        // $data['subjects']=$this->db->select('subject.*')
        //                   ->from('subject')
        //                   ->join('class','class.class_id=subject.class_id')
        //                   ->where('branch',$branch)
        //                   ->where('is_deleted',0)
        //                   ->where('is_delete',0)
        //                   ->get()->result_array();
        
        // $data['subjects']=$this->db->select('subject.*')
        //                   ->from('video_lecture')
        //                   ->JOIN('subject','subject.id=video_lecture.subject')
        //                   ->join('class','class.class_id=subject.class_id')
        //                   ->where('branch',$branch)
        //                   ->where('subject.is_deleted',0)
        //                   ->where('class.is_delete',0)
        //                   ->where('video_lecture.is_delete',0)
        //                   ->group_by('video_lecture.subject')
        //                   ->get()->result_array();
                          
        
        // $data['base_url'] = base_url();
        // $data['userInfo'] = $this->userInfo;

        //     //calling views
        // $this->load->view('header',$data);
        // $this->load->view('sidebar',$data);
        // $this->load->view('Syllabus/lecture_report',$data);
        // $this->load->view('footer',$data);
    }
    public function std_lecture_report()
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        $student_id =$this->user_model->userInfo('student_id')['student_id'];
        
        $branch = $this->db->query("SELECT branch FROM `student` where is_delete='0' AND id = '$student_id'")->result_array();
        $branch = $branch[0]['branch'];
        $data['branch'] = $this->db->query("SELECT id,name FROM `branch` where is_delete='0' and id = '$branch'")->result_array();

            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/std_lecture_report_selection',$data);
        $this->load->view('footer',$data);
    }
    public function watch_report_lecture()
    {
        $this->load->model("report_model");
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        $class=$this->input->post('class');
        
        // $section=$this->input->post('section');
        
        // $data['total_lec']=$this->db->select('count(id) as id')
        //                             ->from('video_lecture')
        //                             ->where('class',$class)
        //                             ->where('is_delete',0)
        //                             ->get()->row_array()['id'];
                                  
        $this->db->select('sid,grno,student_name,father_name,father_contact,dob,promotion.id,class.class_name,class.class_id')
                                   ->from('promotion')
                                   ->join('class','class.class_id=promotion.class_id')
                                   ->join('student','student.id=promotion.student_id');
                                if(!empty($class)){
                                   $this->db->where_in('promotion.class_id',$class);
                                } 
                                   
                                   $this->db->where('is_active',1)
                                            ->where('promotion.is_delete',0)
                                            ->where('student.is_delete',0)
                                            ->where('student.status',0)
                                            ->order_by('promotion.class_id');
           $data['students']=$this->db->get()->result_array();
           
        
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;

            //calling views
   
        $this->load->view('Syllabus/watch_report_lecture',$data);
    }
    
    public function std_watch_report_lecture()
    {
        $this->load->model("report_model");
        $branch=$this->report_model->getBranch()[0];
        
        
        
        $student_id =$this->user_model->userInfo('student_id')['student_id'];
    
    
        $branch = $this->db->query("SELECT branch FROM `student` where is_delete='0' AND id = '$student_id'")->result_array();
        $branch = $branch[0]['branch'];
        $branch_details = $this->db->query("SELECT id,name FROM `branch` where is_delete='0' and id = '$branch'")->result_array();
            
            
        $data['branch_name']=$branch_details[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader($branch);
        
        $class=$this->input->post('class');
        
        // $section=$this->input->post('section');
        
        // $data['total_lec']=$this->db->select('count(id) as id')
        //                             ->from('video_lecture')
        //                             ->where('class',$class)
        //                             ->where('is_delete',0)
        //                             ->get()->row_array()['id'];
                                  
        $this->db->select('sid,grno,student_name,father_name,father_contact,dob,promotion.id,class.class_name,class.class_id')
                                   ->from('promotion')
                                   ->join('class','class.class_id=promotion.class_id')
                                   ->join('student','student.id=promotion.student_id');
                                if(!empty($class)){
                                   $this->db->where_in('promotion.class_id',$class);
                                } 
                                   
                                   $this->db->where('is_active',1)
                                            ->where('promotion.is_delete',0)
                                            ->where('student.id',$student_id)
                                            ->where('student.is_delete',0)
                                            ->where('student.status',0)
                                            ->order_by('promotion.class_id');
           $data['students']=$this->db->get()->result_array();
           
        
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;

            //calling views
   
        $this->load->view('Syllabus/watch_report_lecture',$data);
    }
    public function cbt_report()
    {
        $this->load->model("report_model");
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        $class=$this->input->post('class');
        $data['classes']=$this->db->select('class_name')
                                  ->FROM('class')
                                  ->WHERE('class.is_delete',0)
                                  ->where('class_id',$class)
                                  ->get()->row_array()['class_name'];
                                  
        $section=$this->input->post('section');
        $student_ids=$this->input->post('student_id');
        $data['test_id']=$test=$this->input->post('test');
        
        $this->db->select('sid,grno,student_name,father_name,dob,dateofpaper,totalmarks,student.id,mcq,mcq_marks,mcq_tag,truefalse,truefalse_marks,tf_tag')
                 ->from('paper_history')
                 ->join('test_log','test_log.test_id=paper_history.id')
                 ->join('student','student.id=test_log.cadet_id')
                 ->join('promotion','promotion.student_id=student.id')
                 ->where('test_log.test_id',$test);
           if(!empty($section)){
               $this->db->where('promotion.section_id',$section);
            } 
           
        $this->db->where('is_active',1)
                 ->where('promotion.is_delete',0)
                 ->where('student.is_delete',0)
                 ->where('student.status',0);
        if(!empty($student_ids)){
             $this->db->where_in('student.id',$student_ids);  
           }           
           $this->db->group_by('test_log.cadet_id');
                 
        $data['students']=$this->db->get()->result_array();
 
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;

            //calling views
   
        $this->load->view('Syllabus/cbt_report_print',$data);
    }
    
    public function show_report_lecture()
    {
        $this->load->model("report_model");
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        $class=$this->input->post('class');
        $data["class"]=$this->db->select('*')
                                ->from('class')
                                ->where('class_id',$class)
                                ->get()->row_array();
                                
        $data['subjects']=$this->db->select('subject.*')
                                  ->from('subject')
                                  ->where('class_id',$class)
                                  ->where('is_deleted',0)
                                  ->get()->result_array();
                                  
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;

            //calling views
   
        $this->load->view('Syllabus/lecture_report',$data);
                                
    }
    public function std_show_report_lecture()
    {
        $this->load->model("report_model");
        
        
        $student_id =$this->user_model->userInfo('student_id')['student_id'];
    
    
        $branch = $this->db->query("SELECT branch FROM `student` where is_delete='0' AND id = '$student_id'")->result_array();
        $branch = $branch[0]['branch'];
        $branch_details = $this->db->query("SELECT id,name FROM `branch` where is_delete='0' and id = '$branch'")->result_array();
            
            
        $data['branch_name']=$branch_details[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader($branch);
        
        
        $class=$this->input->post('class');
        $data["class"]=$this->db->select('*')
                                ->from('class')
                                ->where('class_id',$class)
                                ->get()->row_array();
                                
        $data['subjects']=$this->db->select('subject.*')
                                  ->from('subject')
                                  ->where('class_id',$class)
                                  ->where('is_deleted',0)
                                  ->get()->result_array();
                                  
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;

            //calling views
   
        $this->load->view('Syllabus/lecture_report',$data);
                                
    }
     private function do_upload()
    {
        $type = explode('.', $_FILES["pic"]["name"]);
        $type = $type[count($type)-1];
        $url = "./files/".uniqid(rand()).'.'.$type;
        if (in_array($type, array("png","jpg","jpeg","gif","pdf","csv","doc","docx","txt")))
            if(move_uploaded_file($_FILES["pic"]["tmp_name"], $url))
                return $url;
        return null; 
    }
    
    public function add_Announcement()
    {
        $this->user_model->check_permissions("Syllabus/add_Announcement");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;

            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/add_Announcement',$data);
        $this->load->view('footer',$data);
    }
    
    public function add_study_notes()
    {
        $this->user_model->check_permissions("Syllabus/add_study_notes");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/add_notes',$data);
        $this->load->view('footer',$data);
      }
      
    public function add_video_lecture()
    {
        $this->user_model->check_permissions("Syllabus/add_video_lecture");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/add_video_lecture',$data);
        $this->load->view('footer',$data);
      }
      
    public function add()
    {
        $this->user_model->check_permissions("Syllabus/add");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/add',$data);
        $this->load->view('footer',$data);
      }
      
      public function academic_add()
      {
        $this->user_model->check_permissions("Syllabus/academic_add");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/academic_add',$data);
        $this->load->view('footer',$data);
      }
      
      public function add_other()
      {
        $this->user_model->check_permissions("Syllabus/add_other");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/add_other',$data);
        $this->load->view('footer',$data);
      }
      
      public function Syllabus_add()
      {
        $this->user_model->check_permissions("Syllabus/Syllabus_add");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/Syllabus_add',$data);
        $this->load->view('footer',$data);
      }
      
    public function save_annount()
    {
        $des=$this->input->post('description');
        
        $data=array(
            'description'=>$des
            );
        $res=$this->db->insert('popup',$data); 
        
        if($res)
        {
            $this->session->set_flashdata('success','Record save successfully');
        }else{
            $this->session->set_flashdata('error','Error occur while processing try again');
        }
        redirect('Syllabus/add_Announcement');
    }
    
    public function save()
    {
        $class=$this->input->post('class');
        $title=$this->input->post('title');
        $url=$this->do_upload();
        $description=$this->input->post('description');
        $data=array(
            'class'=>$class,
            'title'=>$title,
            'description'=>$description,
            'url'=>$url
            );
        $res=$this->db->insert('syllabus',$data);  
        if($res)
        {
            $this->session->set_flashdata('success','Record save successfully');
        }else{
            $this->session->set_flashdata('error','Error occur while processing try again');
        }
        redirect('Syllabus/add');
    }
    
    public function save_academic()
     {
        $branch=$this->input->post('branch');
        $school_type=$this->input->post('school_type');
        $title=$this->input->post('title');
        $url=$this->do_upload();
        $description=$this->input->post('description');
       
       if(!empty($branch))
       {
           foreach($branch as $row)
           {
                $data=array(
                    'branch_id'=>$row,
                    'school_type'=>$school_type,
                    'title'=>$title,
                    'description'=>$description,
                    'url'=>$url
                    );
                $res=$this->db->insert('academic',$data);  
           }
       }
       
        if($res)
        {
            $this->session->set_flashdata('success','Record save successfully');
        }else{
            $this->session->set_flashdata('error','Error occur while processing try again');
        }
        redirect('Syllabus/academic_add');
    }
    
    public function save_other()
    {
        $branch=$this->input->post('branch');
        $title=$this->input->post('title');
        $url=$this->do_upload();
        $description=$this->input->post('description');
       
       if(!empty($branch))
       {
           foreach($branch as $row)
           {
                $data=array(
                    'branch_id'=>$row,
                    'title'=>$title,
                    'description'=>$description,
                    'url'=>$url
                    );
                $res=$this->db->insert('academic_other',$data);  
           }
       }
       
        if($res)
        {
            $this->session->set_flashdata('success','Record save successfully');
        }else{
            $this->session->set_flashdata('error','Error occur while processing try again');
        }
        redirect('Syllabus/add_other');
    }
    
    public function save_syllabus()
    {
        $branch=$this->input->post('branch');
        $class=$this->input->post('class');
        $type=$this->input->post('type');
        $title=$this->input->post('title');
        $url=$this->do_upload();
        $description=$this->input->post('description');
       
       if(!empty($branch))
       {
           
                $data=array(
                    'branch_id'=>$branch,
                    'class'=>$class,
                    'type'=>$type,
                    'title'=>$title,
                    'description'=>$description,
                    'url'=>$url
                    );
                $res=$this->db->insert('academic_syllabus',$data);  
           
       }
       
        if($res)
        {
            $this->session->set_flashdata('success','Record save successfully');
        }else{
            $this->session->set_flashdata('error','Error occur while processing try again');
        }
        redirect('Syllabus/Syllabus_add');
    }
    
    public function save_notes()
    {
        $class=$this->input->post('class');
        $subject=$this->input->post('subject');
        $title=$this->input->post('title');
        $url=$this->do_upload();
        $description=$this->input->post('description');
       
        $data=array(
            'class'=>$class,
            'subject'=>$subject,
            'title'=>$title,
            'description'=>$description,
            'url'=>$url
            );
        $res=$this->db->insert('study_notes',$data);  
        if($res)
        {
            $this->session->set_flashdata('success','Record save successfully');
        }else{
            $this->session->set_flashdata('error','Error occur while processing try again');
        }
        redirect('Syllabus/add_study_notes');
    }
    
    public function save_lecture()
    {
        $class=$this->input->post('class');
        $subject=$this->input->post('subject');
        $title=$this->input->post('title');
        $link=$this->input->post('link');
        //$url=$this->do_upload();
        $description=$this->input->post('description');
        $time=$this->input->post('time');
       
        $data=array(
            'class'=>$class,
            'subject'=>$subject,
            'title'=>$title,
            'link'=>$link,
            'description'=>$description,
            'time'=>$time
            );
        $res=$this->db->insert('video_lecture',$data);  
        if($res)
        {
            $this->session->set_flashdata('success','Record save successfully');
        }else{
            $this->session->set_flashdata('error','Error occur while processing try again');
        }
        redirect('Syllabus/add_video_lecture');
    }
        
    public function view_Announcement()
    {
        $this->user_model->check_permissions("Syllabus/view_Announcement");
        $data['edit_delete']=$this->user_model->checkEditDelete('Syllabus/view_Announcement');
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        
         $query = $this->db->query("SELECT id,description
                                         FROM `popup`
                                         where popup.is_delete='0'");

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['record'] = $query->result_array();
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/view_Announcement',$data);
    }
    
    public function view()
    {
        $this->user_model->check_permissions("Syllabus/view");
        $data['edit_delete']=$this->user_model->checkEditDelete('Syllabus/view');
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
         if($this->user_model->is_super()){ 
             $query = $this->db->query("SELECT class.class_name,branch.name as b_name,syllabus.id,syllabus.title,syllabus.url,syllabus.description
                                        FROM `syllabus` 
                                        inner join `class` on syllabus.class=class.class_id
                                        inner join `branch` on branch.id=class.branch 
                                        where syllabus.is_delete='0'");
         }else{
             $query = $this->db->query("SELECT class.class_name,syllabus.id,syllabus.title,syllabus.url,syllabus.description
                                         FROM `syllabus` 
                                         inner join `class` on syllabus.class=class.class_id
                                         where syllabus.is_delete='0' and class.branch=$branch");
         }
        

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['record'] = $query->result_array();
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/view',$data);

      }
      public function std_view()
    {
        $data['edit_delete']=false;
        $data['is_super'] = false;
        $data['menu'] = $this->load_model->menu();
        
        $student_id =$this->user_model->userInfo('student_id')['student_id'];
        $branch = $this->db->query("SELECT branch FROM `student` where is_delete='0' AND id = '$student_id'")->result_array();
        $branch = $branch[0]['branch'];
        
        
        
             $query = $this->db->query("SELECT class.class_name,syllabus.id,syllabus.title,syllabus.url,syllabus.description
                                         FROM `syllabus` 
                                         inner join `class` on syllabus.class=class.class_id
                                         JOIN promotion ON class.class_id = promotion.class_id
                                         where promotion.student_id = '$student_id' AND syllabus.is_delete='0' and class.branch=$branch");

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['record'] = $query->result_array();
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/std_view',$data);

      }
      public function academic_view()
       {
        $this->user_model->check_permissions("Syllabus/academic_view");
        $data['edit_delete']=$this->user_model->checkEditDelete('Syllabus/academic_view');
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
         if($this->user_model->is_super()){ 
             $query = $this->db->query("SELECT branch.name as b_name,academic.id,academic.title,academic.url,academic.description,academic.school_type
                                        FROM `academic`
                                        inner join `branch` on branch.id=academic.branch_id
                                        where academic.is_delete='0'");
         }else{
             $query = $this->db->query("SELECT academic.id,academic.title,academic.url,academic.description,academic.school_type
                                         FROM `academic`
                                         where academic.is_delete='0' and academic.branch_id=$branch");
         }
        

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['record'] = $query->result_array();
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/view_academic',$data);

      }
      
      public function view_other()
      {
        $this->user_model->check_permissions("Syllabus/view_other");
        $data['edit_delete']=$this->user_model->checkEditDelete('Syllabus/view_other');
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
         if($this->user_model->is_super()){ 
             $query = $this->db->query("SELECT branch.name as b_name,academic_other.id,academic_other.title,academic_other.url,academic_other.description
                                        FROM `academic_other`
                                        inner join `branch` on branch.id=academic_other.branch_id
                                        where academic_other.is_delete='0'");
         }else{
             $query = $this->db->query("SELECT academic_other.id,academic_other.title,academic_other.url,academic_other.description
                                         FROM `academic_other`
                                         where academic_other.is_delete='0' and academic_other.branch_id=$branch");
         }
        

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['record'] = $query->result_array();
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/view_other',$data);

      }
      
      public function Syllabus_view()
      {
        $this->user_model->check_permissions("Syllabus/Syllabus_view");
        $data['edit_delete']=$this->user_model->checkEditDelete('Syllabus/Syllabus_view');
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
         if($this->user_model->is_super()){ 
             $query = $this->db->query("SELECT branch.name as b_name,class_name,academic_syllabus.id,academic_syllabus.title,academic_syllabus.url,academic_syllabus.description,
                                          academic_syllabus.type
                                        FROM `academic_syllabus`
                                        inner join `branch` on branch.id=academic_syllabus.branch_id
                                        inner join `class` on class.class_id=academic_syllabus.class
                                        where academic_syllabus.is_delete='0'");
         }else{
             $query = $this->db->query("SELECT class_name,academic_syllabus.id,academic_syllabus.title,academic_syllabus.url,academic_syllabus.description,academic_syllabus.type
                                         FROM `academic_syllabus`
                                         inner join `class` on class.class_id=academic_syllabus.class
                                         where academic_syllabus.is_delete='0' and academic_syllabus.branch_id=$branch");
         }
        

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['record'] = $query->result_array();
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/view_academic_syllabus',$data);

      }
      
      public function monthly_calendar()
      {
        $this->user_model->check_permissions("Syllabus/monthly_calendar");
        $data['edit_delete']=$this->user_model->checkEditDelete('Syllabus/monthly_calendar');
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/monthly_calendar',$data);
        $this->load->view('footer',$data);
      }
      
      public function yearly_calendars()
      {
          echo "<h2 style='color:red;text-align:center'>please wait working on it...........</h2>";
      }
     
     public function view_notes()
     {
        $this->user_model->check_permissions("Syllabus/view_notes");
        $data['edit_delete']=$this->user_model->checkEditDelete('Syllabus/view_notes');
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
         if($this->user_model->is_super()){ 
             $query = $this->db->query("SELECT class.class_name,subject.name,branch.name as b_name,study_notes.id,study_notes.title,study_notes.url,study_notes.description
                                        FROM `study_notes` 
                                        inner join `class` on study_notes.class=class.class_id 
                                        inner join `subject` on subject.id=study_notes.subject 
                                        inner join `branch` on branch.id=class.branch 
                                        where study_notes.is_delete='0'");
         }else{
             $query = $this->db->query("SELECT class.class_name,subject.name,study_notes.id,study_notes.title,study_notes.url,study_notes.description
                                         FROM `study_notes` 
                                         inner join `class` on study_notes.class=class.class_id 
                                         inner join `subject` on subject.id=study_notes.subject
                                         where study_notes.is_delete='0' and class.branch=$branch");
         }
        

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['record'] = $query->result_array();
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/view_notes',$data);

      }
     public function std_view_notes()
     {
        $data['edit_delete']=false;
        $data['is_super'] = false;
        $data['menu'] = $this->load_model->menu();
        
        $student_id =$this->user_model->userInfo('student_id')['student_id'];
    
    
        $branch = $this->db->query("SELECT branch FROM `student` where is_delete='0' AND id = '$student_id'")->result_array();
        $branch = $branch[0]['branch'];
        $data['branch'] = $this->db->query("SELECT id,name as b_name FROM `branch` where is_delete='0' and id = '$branch'")->result_array();
            
        
             $query = $this->db->query("SELECT class.class_name,subject.name,study_notes.id,study_notes.title,study_notes.url,study_notes.description
                                         FROM `study_notes` 
                                         inner join `class` on study_notes.class=class.class_id 
                                         inner join `subject` on subject.id=study_notes.subject
                                        JOIN promotion ON class.class_id = promotion.class_id  
                                         where  promotion.student_id = '$student_id' AND study_notes.is_delete='0' and class.branch=$branch");

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['record'] = $query->result_array();
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/std_view_notes',$data);

      }
      
     public function view_video_lecture()
     {
        $this->user_model->check_permissions("Syllabus/view_video_lecture");
        $data['edit_delete']=$this->user_model->checkEditDelete('Syllabus/view_video_lecture');
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
         if($this->user_model->is_super()){ 
             $query = $this->db->query("SELECT time,show_status,class.class_name,subject.name,branch.name as b_name,video_lecture.id,video_lecture.title,video_lecture.url,video_lecture.link,video_lecture.description
                                        FROM `video_lecture` 
                                        inner join `class` on video_lecture.class=class.class_id 
                                        inner join `subject` on subject.id=video_lecture.subject 
                                        inner join `branch` on branch.id=class.branch 
                                        where video_lecture.is_delete='0' and class.is_delete='0' and subject.is_deleted=0 order by video_lecture.id desc");
         }else{
             $query = $this->db->query("SELECT time,show_status,class.class_name,subject.name,video_lecture.id,video_lecture.title,video_lecture.link,video_lecture.url,video_lecture.description
                                         FROM `video_lecture` 
                                         inner join `class` on video_lecture.class=class.class_id 
                                         inner join `subject` on subject.id=video_lecture.subject
                                         where video_lecture.is_delete='0' and class.is_delete='0' and subject.is_deleted=0 and class.branch=$branch order by video_lecture.id desc");
         }
        

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['record'] = $query->result_array();
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/view_video_lecture',$data);

      }
      
     public function std_view_video_lecture()
     {
        $data['edit_delete']=false;
        $data['is_super'] = false;
        $data['menu'] = $this->load_model->menu();
        
        $student_id =$this->user_model->userInfo('student_id')['student_id'];
    
    
        $branch = $this->db->query("SELECT branch FROM `student` where is_delete='0' AND id = '$student_id'")->result_array();
        $branch = $branch[0]['branch'];
        $data['branch'] = $this->db->query("SELECT id,name as b_name FROM `branch` where is_delete='0' and id = '$branch'")->result_array();
            
        
         $query = $this->db->query("SELECT time,show_status,class.class_name,subject.name,video_lecture.id,video_lecture.title,video_lecture.link,video_lecture.url,video_lecture.description
                                     FROM `video_lecture` 
                                     inner join `class` on video_lecture.class=class.class_id 
                                     inner join `subject` on subject.id=video_lecture.subject
                                     JOIN promotion ON class.class_id = promotion.class_id 
                                     where  promotion.student_id = '$student_id' AND video_lecture.is_delete='0' and class.is_delete='0' and subject.is_deleted=0 and class.branch=$branch order by video_lecture.id desc");
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['record'] = $query->result_array();
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/std_view_video_lecture',$data);

      }
      
      public function question($id)
      {

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        $data['lec_id']=$id;
		$data['user_id']= $this->user_model->userInfo()['id'];
                                   
        $data['records']=$this->db->select('query_board.description,query_board.insert_log,admin.first_name')
                                  ->from('query_board')
                                  ->join('admin','admin.id=query_board.user_id')
                                  ->where('lec_id',$id)
                                  ->get()->result_array();
         
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
            //===========================================
        
            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/query_board',$data);
      }
      
    public function save_query()
    {
        $query=trim($_POST['query']);
        $user_id=$_POST['user_id'];
        $lec_id=$_POST['lec_id'];
        
        $data=array(
            'lec_id'=>$lec_id,
            'user_id'=>$user_id,
            'description'=>$query
            );
        $this->db->insert('query_board',$data);
        echo "true";
        
    }

public function paid_emp()
{
   $ids=$this->input->post('employees_pay');
   if(!empty($ids))
   {
       foreach($ids as $row)
       {
           
           $data=array(
            'show_status'=>1
           );
        
    $this->db->where('id',$row)  
             ->update('video_lecture',$data);
       }
   }
   redirect('Syllabus/view_video_lecture');  
}

public function disable_show($id)
{
    $data=array(
        'show_status'=>1
        );
        
    $this->db->where('id',$id)  
             ->update('video_lecture',$data);
    redirect('Syllabus/view_video_lecture');        
}

public function enable_show($id)
{
    $data=array(
        'show_status'=>0
        );
        
    $this->db->where('id',$id)  
             ->update('video_lecture',$data);
    redirect('Syllabus/view_video_lecture');          
}

public function edit_spectial($id)
{
    $data['is_super'] = $this->user_model->is_super();
    $data['menu'] = $this->load_model->menu();
    $branch=$this->user_model->getbranch();
    
    $data['base_url'] = base_url();
    $data['userInfo'] = $this->userInfo;
    
    $data['records']=$this->db->select('*')
                           ->from('popup')
                           ->where('id',$id)
                           ->get()->row_array();
                           
    //calling views
    $this->load->view('header',$data);
    $this->load->view('sidebar',$data);
    $this->load->view('Syllabus/edit_spectial',$data);
    $this->load->view('footer',$data);                       
}

     public function edit_lecture($id)
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        $data['records']=$this->db->select('*')
                                   ->from('video_lecture')
                                   ->where('id',$id)
                                   ->get()->row_array();
         
        $get_branch=$this->db->select('branch')
                              ->from('class')
                              ->where('class_id',$data['records']['class'])
                              ->get()->row_array()['branch'];
                              
        $data['subject']=$this->db->select('subject.id,subject.name')
                                  ->from('subject')  
                                  ->where('subject.class_id',$data['records']['class'])
                                  ->where('subject.is_deleted',0)
                                  ->get()->result_array(); 
                                  
        $data['classes']=$this->db->select('class_id,class_name')
                                  ->from('class')
                                  ->where('branch',$get_branch)
                                  ->where('is_delete',0)
                                  ->get()->result_array();
                     
         

            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/edit_video_lecture',$data);
        $this->load->view('footer',$data);
    } 
    
    public function view_lecture($id)
    {
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        $data['records']=$this->db->select('*')
                                   ->from('video_lecture')
                                   ->where('id',$id)
                                   ->get()->row_array();
                                   
        //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('Syllabus/single_video_lecture',$data);
        $this->load->view('footer',$data);                           
    }
    
    public function update_annount($id)
    {
        $description=$this->input->post('description');
        $data=array(
            'description'=>$description
            );
        $res=$this->db->where('id',$id)
                      ->update('popup',$data);  
        if($res)
        {
            $this->session->set_flashdata('success','Record update successfully');
        }else{
            $this->session->set_flashdata('error','Error occur while processing try again');
        }
        redirect('Syllabus/view_Announcement');
    }
    
     public function update_lecture()
    {
        $edit_id=$this->input->post('edit_id');
        // $old_url=$this->input->post('old_url');
        
        $class=$this->input->post('class');
        $subject=$this->input->post('subject');
        $title=$this->input->post('title');
        $link=$this->input->post('link');
        // $validator=$_FILES['pic']['name'];
        
        // if(!empty($validator))
        // {
        //     $url=$this->do_upload();
        // }else{
        //     $url=$old_url;
        // }
        
        $description=$this->input->post('description');
        $time=$this->input->post('time');
       
        $data=array(
            'class'=>$class,
            'subject'=>$subject,
            'title'=>$title,
            'link'=>$link,
            'description'=>$description,
            'time'=>$time
            );
        $res=$this->db->where('id',$edit_id)
                      ->update('video_lecture',$data);  
        if($res)
        {
            $this->session->set_flashdata('success','Record update successfully');
        }else{
            $this->session->set_flashdata('error','Error occur while processing try again');
        }
        redirect('Syllabus/view_video_lecture');
    }
    
    public function delete_spectial($id)
    {
        $id=$id;
            $data=array(
                'is_delete'=>1
                );
            $res=$this->db->where('id',$id)
                     ->update('popup',$data);
                     
            if($res)
            {
                $this->session->set_flashdata('success','Record Deleted');
            }else{
                $this->session->set_flashdata('error','Error occur while processing try again');
            }
            redirect('Syllabus/view_Announcement'); 
    }
    
     public function delete_lecture($id)
      {
           $id=$id;
            $data=array(
                'is_delete'=>1
                );
            $res=$this->db->where('id',$id)
                     ->update('video_lecture',$data);
                     
            if($res)
            {
                $this->session->set_flashdata('success','Record Deleted');
            }else{
                $this->session->set_flashdata('error','Error occur while processing try again');
            }
            redirect('Syllabus/view_video_lecture'); 
      }
        
     public function delete_study($id)
       {
            $id=$id;
            $data=array(
                'is_delete'=>1
                );
            $res=$this->db->where('id',$id)
                     ->update('study_notes',$data);
                     
            if($res)
            {
                $this->session->set_flashdata('success','Record save Deleted');
            }else{
                $this->session->set_flashdata('error','Error occur while processing try again');
            }
            redirect('Syllabus/view_notes'); 
        }
       
     public function delete_Syllabus($id)
       {
            $id=$id;
            $data=array(
                'is_delete'=>1
                );
            $res=$this->db->where('id',$id)
                     ->update('syllabus',$data);
                     
            if($res)
            {
                $this->session->set_flashdata('success','Record save Deleted');
            }else{
                $this->session->set_flashdata('error','Error occur while processing try again');
            }
            redirect('Syllabus/view'); 
        }
    
    public function delete_academic($id)
       {
            $id=$id;
            $data=array(
                'is_delete'=>1
                );
            $res=$this->db->where('id',$id)
                     ->update('academic',$data);
                     
            if($res)
            {
                $this->session->set_flashdata('success','Record save Deleted');
            }else{
                $this->session->set_flashdata('error','Error occur while processing try again');
            }
            redirect('Syllabus/academic_view'); 
        }    
        
    public function delete_academic_syllabus($id)
    {
            $id=$id;
            $data=array(
                'is_delete'=>1
                );
            $res=$this->db->where('id',$id)
                     ->update('academic_syllabus',$data);
                     
            if($res)
            {
                $this->session->set_flashdata('success','Record save Deleted');
            }else{
                $this->session->set_flashdata('error','Error occur while processing try again');
            }
            redirect('Syllabus/Syllabus_view'); 
    } 
    
    public function delete_other($id)
     {
            $id=$id;
            $data=array(
                'is_delete'=>1
                );
            $res=$this->db->where('id',$id)
                     ->update('academic_other',$data);
                     
            if($res)
            {
                $this->session->set_flashdata('success','Record save Deleted');
            }else{
                $this->session->set_flashdata('error','Error occur while processing try again');
            }
            redirect('Syllabus/view_other'); 
    }        

}
?>
