<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Hostel Class
 *
 * @package     hostel
 * @subpackage  hostel_management
 * @author      John
 */

class Hostel extends CI_Controller {

    private $userInfo = array();

    public function __construct()
    {
        parent::__construct();
        $this->load->model("user_model");
        $this->load->model("hostel_model");
        $this->user_model->check_login("admin");

        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
    }

    public function index()
    {
        $this->user_model->check_permissions("hostel/index");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;

        // Fetch hostel records
        $data['result'] = $this->Hostel_model->get_hostel()->result_array();


        // Load views
        $this->load->view('header', $data);
        $this->load->view('sidebar', $data);
        $this->load->view('hostel/index', $data);
    }

    public function save()
    {
        if ($this->input->post()) {
            $data = array(
                'hostel_name' => $this->input->post('hostel_name'),
                'class'       => $this->input->post('class'),
                'section'     => $this->input->post('section'),
                'type'        => $this->input->post('type'),
                'room'        => $this->input->post('room'),
                'bed'         => $this->input->post('bed'),
                'date'        => $this->input->post('date'),
            );

            $this->hostel_model->save($data);
            redirect("hostel/view_hostel", "refresh");
        } else {
            redirect("hostel/hostel/index", "refresh");
        }
    }

public function view_hostel()
{
    $this->user_model->check_permissions("hostel/view_hostel");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
    // Load the database
    $this->load->database();
    

    //$data['hostel'] = $this->Hostel_model->get_hostel()->result_array();
    //$this->load->view('hostel/view_hostel', $data);



    // Fetch hostel data
   $query = $this->db->get('hostel');
   $data['hostel'] = $query->result();

    // Load the view
    $this->load->view('header', $data);
    $this->load->view('sidebar', $data);
    $this->load->view('hostel/view_hostel', $data);
}

    public function edit($id)
    {
        $data['menu'] = $this->load_model->menu();
        $data['userInfo'] = $this->userInfo;
        $data['base_url'] = base_url();
        $data['hostel'] = $this->hostel_model->get_by_id($id);

        $this->load->view('header', $data);
        $this->load->view('sidebar', $data);
        $this->load->view('hostel/edit_hostel', $data);
    }

    public function update()
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            $data = array(
                'hostel_name' => $this->input->post('hostel_name'),
                'class'       => $this->input->post('class'),
                'section'     => $this->input->post('section'),
                'type'        => $this->input->post('type'),
                'room'        => $this->input->post('room'),
                'bed'         => $this->input->post('bed'),
                'date'        => $this->input->post('date'),
            );

            $this->hostel_model->update($id, $data);
            redirect("hostel/view_hostel", "refresh");
        } else {
            redirect("hostel/index", "refresh");
        }
    }

    // Delete hostel record
    public function delete($id) {
        $this->db->where('id', $id);
        return $this->db->delete('hostel');
        $this->session->set_flashdata('success_msg', 'Payment has been deleted.');
		redirect('hostel/view_hostel');
    }
}
