<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * staff Class
 *
 * @package     edusol
 * @subpackage  certificate
 * @author      Atif Razzaq
 * @link        http://atifrazzaq.arteck.xyz
 */
class certificate extends CI_Controller {

    private $userInfo = array();

    public function __construct()
    {
        parent::__construct();
        $this->load->model("user_model");
        $this->load->model("certificate_model");
        $this->user_model->check_login("admin");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
    }


    public function index()
    {
         $this->user_model->check_permissions("certificate/index");
         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
         $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                                

         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
                // calling view pages
         $this->load->view('header',$data);
         $this->load->view('sidebar',$data);
         $this->load->view('certificate/select_class',$data);
    }

                // reciving values of class and certificate and showing student
    public function select_class()
    {
        if($this->input->post())
        {   
                $values= $this->input->post();
                $certificate= $this->input->post('certificate');
                $data['student']=$this->certificate_model->select_student($values);
                $data['file'] = $this->db->query("SELECT id,file FROM `certificate` WHERE `id`='$certificate' AND `is_active`='1' AND `is_delete`='0'")->result();
                $data['menu'] = $this->load_model->menu();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;

                if($values['for_student']=='deactive' && $certificate==4) {
                    $data['check_fee']="true";
                }else{
                    $data['check_fee']="false";
                }

                if($certificate==4){
                    $data['is_leaving']="true";
                }             
                    
                $this->load->view('header',$data);
                $this->load->view('sidebar',$data);
                $this->load->view('certificate/certificate_student_list',$data);
        }
        else{
            redirect("certificate/index","refresh");
        }
        
    }


    public function deactive()
    {   
        if($this->uri->segment(3))
         {
           $id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
             
             $this->certificate_model->deactive($id);
             redirect('certificate/edit','refresh');
         }
         else
         {
             redirect('certificate/edit','refresh');

         }
    }

    public function active()
    {
        if($this->uri->segment(3))
        {
              $id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
            $this->certificate_model->active($id);
             redirect('certificate/edit','refresh');

        }
        else
        {
             redirect('certificate/edit','refresh');
            
        }
    }

    /*
            ============================================
                     Leave
            ============================================

    */

      public function leave()
    {
         $this->user_model->check_permissions("certificate/leave");
            
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
             $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                    

            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('certificate/add_leave_info',$data);
        
            }
    public function leave_info()
    {
          if($this->input->post())
            {
                $data=$this->input->post();
                $this->certificate_model->add_leave_info($data);
                redirect("certificate/leave","refresh");
                
            }
            else
            {
                redirect("certificate/leave","refresh");
            }
    }
    
   
    
    
    
    
   public function view_leave($p=1)
    {
      $this->user_model->check_permissions("certificate/view_leave");
$data['edit_delete']=$this->user_model->checkEditDelete('certificate/view_leave');

         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
        if(!$this->user_model->is_super()){ 
            $branch=$this->user_model->getbranch();
            $this->db->where('leave_info.branch',$branch);
            $this->db->where('leave_info.is_delete','0');
            $this->db->select('leave_info.id as Lid,student.grno,student.sid,student.student_name,leave_info.conduct,leave_info.progress,leave_info.dol '); 
            $this->db->from('leave_info');
            $this->db->join('student',"student.id=leave_info.std_id");
            $query = $this->db->get();
          }
          if($this->user_model->is_super()){ 
            $this->db->where('leave_info.is_delete','0');
            $this->db->select('leave_info.id as Lid,branch.name as b_name, student.grno,student.sid,student.student_name,leave_info.conduct,leave_info.progress,leave_info.dol '); 
            $this->db->from('leave_info');
            $this->db->join('student',"student.id=leave_info.std_id");
            $this->db->join('branch',"branch.id=leave_info.branch");
            $query = $this->db->get();
          }
        
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
        $data['leave'] = $query->result_array();
        
                // calling view pages
         $this->load->view('header',$data);
         $this->load->view('sidebar',$data);
         $this->load->view('certificate/view_leave_info',$data);   
    }
    
/*
            ========================================
                provisional 
            ========================================
*/
    public function provisional()
    {
      $this->user_model->check_permissions("certificate/provisional");
          
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
              $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                      

            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('certificate/add_provisional_info',$data);
        
            }
    public function provisional_info()
    {
          if($this->input->post())
            {
                $data=$this->input->post();
                $this->certificate_model->add_provisional_info($data);
                redirect("certificate/provisional","refresh");
                
            }
            else
            {
                redirect("certificate/provisional","refresh");
            }
    }

    public function provisional_view($p=1)
    {
         $this->user_model->check_permissions("certificate/provisional_view");
$data['edit_delete']=$this->user_model->checkEditDelete('certificate/provisional_view');

         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
        $total = $this->db->query("SELECT count(*) as total FROM `pro_info` where is_delete='0'")->result_array()[0]['total'];
        if(!$this->user_model->is_super()){
            $branch=$this->user_model->getbranch();
            $this->db->where('pro_info.branch',$branch);
            $this->db->where('pro_info.is_delete','0');
            $this->db->select("*,pro_info.id as p_id"); 
            $this->db->from('pro_info');
            $this->db->join('student',"student.id=pro_info.std_id");
            $query = $this->db->get();
        }
        if($this->user_model->is_super()){
            $this->db->where('pro_info.is_delete','0');
            $this->db->select("*,pro_info.id as p_id,branch.name as b_name"); 
            $this->db->from('pro_info');
            $this->db->join('student',"student.id=pro_info.std_id");
            $this->db->join('branch',"branch.id=pro_info.branch");
            $query = $this->db->get();
        }
        
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
        $data['leave'] = $query->result_array();
        //$data['total'] = ceil($total / $per_page);
                // calling view pages
         $this->load->view('header',$data);
         $this->load->view('sidebar',$data);
         $this->load->view('certificate/view_provisional_info',$data);   
          
     }
      public function edit_p() 
    {
           if($this->uri->segment(3))
        {
        
                $pro_id=explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
 $query=$query=$this->db->query("select * from pro_info where id = $pro_id");
             $data['pro_info'] = $query->row();

//var_dump($data['pro_info']); die();

     $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
     
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('header',$data);
         $this->load->view('sidebar',$data);
         $this->load->view('certificate/update_pro_info',$data);  
        }
        else
        {
            redirect('certificate/provisional_view','refresh');
        }
        
    }
    
    public function update_pro_info()
    {
         if($this->input->post())
            {
                //var_dump($this->input->post());die();
                $data=$this->input->post();
               $id=$this->input->post('id');
               // var_dump($id); die();
                $this->db->where('id',$id)->update('pro_info',$data);
                
                
                
               // $this->certificate_model->add_leave_info($data);
                redirect("certificate/provisional_view","refresh");
                
            }
            else
            {
                redirect("certificate/provisional_view","refresh");
            }
        
        
    }
     
     
     
    public function edit()
    {
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['certificate']= $this->certificate_model->getcertificate();

            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('certificate/view_certificate',$data);
    }



    
    public function edit_leave_info()
    {  
       //var_dump($this->uri->segment(3)); die();
        
        if($this->uri->segment(3))
        {
             $branch=$this->user_model->getbranch();
                $leave_id=explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
 $query=$query=$this->db->query("select * from leave_info where id = $leave_id");
             $data['leave_info'] = $query->row();

//var_dump($data['leave_info']); die();
$data['classes'] = $this->db->select('*')->from('class')->where('branch',$branch)->where('is_delete', '0')->get()->result_array();

     $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
     
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('header',$data);
         $this->load->view('sidebar',$data);
         $this->load->view('certificate/update_leave_info',$data);  
              
              

        }
        else
        {
            redirect('certificate/index','refresh');
        }
    }
     public function Update_leave_info()
    { 
        //var_dump($this->input->post()); die();
         if($this->input->post())
            {
                $data=$this->input->post();
               $id=$this->input->post('id');
               // var_dump($id); die();
                $this->db->where('id',$id)->update('leave_info',$data);
                
                
                
               // $this->certificate_model->add_leave_info($data);
                redirect("certificate/view_leave","refresh");
                
            }
            else
            {
                redirect("certificate/leave","refresh");
            }
        
        
    }
    public function delete_leave_info(){
        if($this->uri->segment(3))
        {
                $leave_id=explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
                $this->db->where('id',$leave_id)->delete('leave_info');
                
                redirect("certificate/view_leave","refresh");
        }else{
            echo 'error some!';
        }
    }

/*     ====================================================
           certificates method for printing   
       ====================================================
*/
   
    
    
     public function character()
    {
         if($this->input->post('std[]'))
        {    $data['duplicate'] = $this->input->post('duplicate[]');
             foreach ($this->input->post('std[]') as $value) 
                {
             
                   $data['studentcer']=@$this->db->query("SELECT student.*,class.*,taluka.name as taluka_name,province.province_name as province_name,promotion.*,student.id as id FROM `student` INNER join `promotion` on student.id = promotion.student_id  
                    INNER join `class` on  promotion.class_id=class.class_id 
                    INNER join `taluka` on  student.taluka=taluka.id
                    INNER join `province` on  student.province=province.Province_id
                    where student.id='$value' and promotion.is_active='1'")->result_array();
                    $data['b_header'] = @$this->db->query("SELECT `title`,`tagline`,`short_address`,`phone_no`,`email`,`logo1`,`logo2` FROM `branch` WHERE `id`='".$data['studentcer'][0]['branch']."' AND `is_delete`='0'")->result_array()[0];
                    $this->load->view('certificate/character',$data);
                }
       } 
        else
         {
            redirect('certificate/index','refresh');
         }

    }

    
    
    
     public function sports()
    {
         if($this->input->post('std[]'))
         {
             $data['duplicate'] = $this->input->post('duplicate[]');

             foreach ($this->input->post('std[]') as $value) 
               {
                   $data['studentcer']=@$this->db->query("SELECT student.*,class.*,promotion.*,student.id as id FROM `student` INNER join `promotion` on student.id = promotion.student_id  
                    INNER join `class` on  promotion.class_id=class.class_id 
                    where student.id='$value' and promotion.is_active='1'")->result_array();
                    $data['b_header'] = @$this->db->query("SELECT `title`,`tagline`,`short_address`,`phone_no`,`email`,`logo1`,`logo2` FROM `branch` WHERE `id`='".$data['studentcer'][0]['branch']."' AND `is_delete`='0'")->result_array()[0];
                   $this->load->view('certificate/sports',$data);
                }    
        
         }
         else
         {
            redirect('certificate/index','refresh');
         }
        }


    public function provisionall()
    {
         if($this->input->post('std[]'))
         {
            $data['duplicate'] = $this->input->post('duplicate[]');
             foreach ($this->input->post('std[]') as $value) 
        {
           $data['studentcer']=@$this->db->query("SELECT student.*,class.*,promotion.*,student.id as id FROM `student` INNER join `promotion` on student.id = promotion.student_id  
                    INNER join `class` on  promotion.class_id=class.class_id 
                    where student.id='$value' and promotion.is_active='1'")->result_array();
                    $data['b_header'] = @$this->db->query("SELECT `title`,`tagline`,`short_address`,`phone_no`,`email`,`logo1`,`logo2` FROM `branch` WHERE `id`='".$data['studentcer'][0]['branch']."' AND `is_delete`='0'")->result_array()[0];
                   $this->load->view('certificate/provisional',$data);
                           
        }   
         }
            else{
            redirect('certificate/index','refresh');

            }
             
        }

     public function leaving()
    {
        $post=$this->input->post('std[]');

         if($this->input->post('std[]'))
         {
            $passed=$this->input->post('passed');
            $data['duplicate'] = $this->input->post('duplicate[]');

             foreach ($this->input->post('std[]') as $value) 
           {
         
            $data['studentcer']=@$this->db->query("SELECT student.*,class.*,promotion.*,student.id as id 
                                                   FROM `student`
                                                   INNER join `promotion` on student.id = promotion.student_id  
                                                   INNER join `class` on  promotion.class_id=class.class_id  
                    where student.id='$value' and promotion.is_active='1'")->result_array();
            // var_dump('<pre>',$data['studentcer']);
            // die();
                    
            if(isset($passed[$value]) && $passed[$value]=="true"){
                $data['passed']="true";
            }else {
                $data['passed']="false";
            }
$data['leave_class']=$this->db->select('class_name')
                              ->from('leave_info')
                              ->join('class','class.class_id=leave_info.class_in_which_left')
                              ->where('std_id',$value)
                              ->where('leave_info.is_delete',0)
                              ->get()->row_array()['class_name'];
//var_dump($data['leave_class']);die();

            $data['b_header'] = @$this->db->query("SELECT `title`,`tagline`,`short_address`,`phone_no`,`email`,`logo1`,`logo2` FROM `branch` WHERE `id`='".$data['studentcer'][0]['branch']."' AND `is_delete`='0'")->result_array()[0]; 
            $this->load->view('certificate/school-leaving',$data);
                           
        }

    }
            else{
               
            redirect('certificate/index','refresh');
                
            }    
        }    
            
}
