<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * staff Class
 *
 * @package     edusol
 * @subpackage  Syllabus
 * @author      Atif Razzaq
 * @link        http://atifrazzaq.arteck.xyz
 */
class CBT extends CI_Controller {

    private $userInfo = array();

    public function __construct()
    {
        parent::__construct();
        $this->load->model("user_model");
        $this->user_model->check_login("admin");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
    }

     public function index()
    {
    
    }
    
    public function paper_retake()
    {
        $this->user_model->check_permissions("CBT/paper_retake");

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();


            //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('cbt/retake_paper',$data);
        $this->load->view('footer',$data);
    }
    
    public function retake()
    {
        $test=$this->input->post('test');
        $student=$this->input->post('student');
        if(!empty($student))
        {
            foreach($student as $row)
            {
               $cadet_id=$row;
               $this->db->where('test_id',$test)
                        ->where('cadet_id',$cadet_id)
                        ->delete('test_log');
                        
              $this->db->where('test_id',$test)
                        ->where('cadet_id',$cadet_id)
                        ->delete('paper_result');            
               
            }
          $this->session->set_flashdata('success','Successfully Role back');    
        }else{
            $this->session->set_flashdata('error','Error occur while processing try again');
        }
        
        redirect('CBT/paper_retake');
    }
    
     private function do_upload()
    {
        $type = explode('.', $_FILES["pic"]["name"]);
        $type = $type[count($type)-1];
        $url = "./files/".uniqid(rand()).'.'.$type;
        if (in_array($type, array("png","jpg","jpeg","gif","pdf","csv","doc","docx","txt")))
            if(move_uploaded_file($_FILES["pic"]["tmp_name"], $url))
                return $url;
        return null; 
    }
    
    public function create_paper()
    {
            $this->user_model->check_permissions("CBT/create_paper");
    
             $data['is_super'] = $this->user_model->is_super();
             $data['menu'] = $this->load_model->menu();
             $branch=$this->user_model->getbranch();
                if($this->user_model->is_super())
                    $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
                else
                   $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
             $data['base_url'] = base_url();
             $data['userInfo'] = $this->userInfo;
             $this->load->view('header',$data);
             $this->load->view('sidebar',$data);
             $this->load->view('cbt/question_selection',$data);
    }
      
public function get_question_print()
{
    if($this->input->post())
    {
      $branch=$this->user_model->getBranch();
      $data['data']=$data=$posting=$this->input->post();
      $class=$this->input->post('class');
      $subject=$this->input->post('subject');
    //   var_dump('<pre>',$data);
    //   die();
      
      if(!empty($data['mcq']) && !empty($data['mcq_marks']) ){
          
           $subject=$data['subject'];
           $c=0;
           $chapter=$data['chapter'];   
           $count=count($data['chapter']);
           $level=$data['level'];
           $class=$data['class'];
           
        $paper_history=array(
             'branch'=>$posting['branch'],
             'class'=>$posting['class'],
             'subject'=>$posting['subject'],
             'level'=>$posting['level'],
             'dateofpaper'=>$posting['dateofpaper'],
             'time'=>$posting['time'],
             'totalmarks'=>$posting['totalmarks'],
             'mcq_tag'=>$posting['mcq_tag'],
             'mcq'=>$posting['mcq'],
             'mcq_marks'=>$posting['mcq_marks'],
             'tf_tag'=>$posting['tf_tag'],
             'truefalse'=>$posting['truefalse'],
             'truefalse_marks'=>$posting['truefalse_marks'],
             'created_by'=>$uid= $this->user_model->userInfo("id")['id']
            );
            
      
        
        foreach($chapter as $key=> $chap){
           $checkpara= $this->db->query("SELECT * FROM `mcq_questions` where class=$class AND subject=$subject AND chapter=$chap AND  level='$level' ")->result_array();
          $c+=count($checkpara);
         }

        if($c>0)  {
           $history=$this->db->insert('paper_history',$paper_history);
           $insert_id=$this->db->insert_id();
           $chapter_array=array();
           foreach($chapter as $key=> $chap){
               $chapter_array[]=array(
                   'paper_id'=>$insert_id,
                   'chapter_id'=>$chap
                   );
         }
         
           $this->db->insert_batch('paper_chapters', $chapter_array);
           $mcq_limit=$data['mcq'];
           $this->db->select('mcq_questions.id');
           $this->db->from('mcq_questions');
           $this->db->where('mcq_questions.is_delete',0);
           $this->db->where_in('mcq_questions.chapter', $chapter);
           $query_print=$this->db->where('mcq_questions.level',$level)->order_by('rand()')->limit($mcq_limit)->get()->result_array();
           
           if(!empty($query_print))
           {
               $paper_questions=array();
               foreach($query_print as $row)
               {
                  $paper_questions[]=array(
                   'paper_id'=>$insert_id,
                   'question_id'=>$row['id']
                   ); 
               }
              $this->db->insert_batch('paper_questions', $paper_questions); 
           }
           
           if(!empty($data['truefalse'])){
           //True False
           $tf_limit=$data['truefalse'];
           $this->db->select('general_questions.id');
           $this->db->from('general_questions');
           $this->db->where('general_questions.is_delete',0);
           $this->db->where('general_questions.question_type',19);
           $this->db->where_in('general_questions.chapter', $chapter);
           $query_print2=$this->db->where('general_questions.level',$level)->order_by('rand()')->limit($tf_limit)->get()->result_array();
           
           if(!empty($query_print2))
           {
               $paper_questions2=array();
               foreach($query_print2 as $row)
               {
                  $paper_questions2[]=array(
                   'paper_id'=>$insert_id,
                   'question_id'=>$row['id'],
                   'is_mcq'=>1
                   ); 
               }
              $this->db->insert_batch('paper_questions', $paper_questions2); 
           }
           }
           
        }    
      }
    
      redirect('CBT/view_paper');
    }
   
  }
  
public function view_paper()
{
         $this->user_model->check_permissions("CBT/view_paper");
         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
         $branch=$this->user_model->getbranch();

         $this->db->select("paper_history.id,paper_history.is_publish,dateofpaper,totalmarks,(mcq+truefalse) as mcq ,time,subject.name as subject_name,class_name,paper_history.is_delete")
                                    ->from("paper_history")
                                    ->join('subject','subject.id=paper_history.subject')
                                    ->join('class','class.class_id=paper_history.class')
                                    ->where('paper_history.is_delete',0);
                                if(!$this->user_model->is_super()){            
                                    $this->db->where('paper_history.branch',$branch);
                                }
         $data['paper_history']=$this->db->get()->result_array();
       
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('header',$data);
         $this->load->view('sidebar',$data);
         $this->load->view('cbt/view_paper',$data); 
}

public function publish($id)
{
    $data=array(
             'is_publish'=>1
             );
             $this->db->where('id',$id)
                      ->update('paper_history',$data);
         redirect('CBT/view_paper');
}

public function unpublish($id)
{
    $data=array(
             'is_publish'=>0
             );
             $this->db->where('id',$id)
                      ->update('paper_history',$data);
         redirect('CBT/view_paper');
}

public function print_paper_sheet($id)
{
  $branch=$this->user_model->getBranch();
  $data['data']=$data=$this->db->select('*')->from('paper_history')->where('id',$id)->get()->row_array();
  $class=$data['class'];
 
  $subject=$data['subject'];
  
      $data['b_header']=$this->db->query("SELECT * FROM `branch` WHERE is_delete='0' AND id='$branch'")->row_array();
      //var_dump('<pre>',$data['b_header']);
      //die();
      $data['classes']=$this->db->select('class_name')
                                ->FROM('class')
                                ->WHERE('class.is_delete',0)
                                ->where('class_id',$class)
                                ->get()->row_array()['class_name'];
    //   var_dump('<pre>',$data['classes']);
    //   die();
      $data['subject']= $this->db->query("SELECT name FROM `subject`  WHERE subject.is_deleted='0'  AND id=$subject")->row_array();
      $this->load->view('cbt/paper_print',$data);
}

public function print_paper_sheet_delete($id)
{

         $data=array(
             'is_delete'=>1
             );
             $this->db->where('id',$id)
                      ->update('paper_history',$data);
         redirect('CBT/view_paper');
}
     

}
