<?php
include "zklibrary.php";
defined('BASEPATH') OR exit('No direct script access allowed');


class Biometric extends CI_Controller {

    private $userInfo = array();

    public function __construct()
    {
        parent::__construct();
        $this->load->library('hajanasms');
    }

     public function index()
    {
        $this->user_model->check_login("admin");
        $this->load->model("user_model");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
        $this->user_model->check_permissions("Biometric/index");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch = $this->user_model->getBranch();
       
        $query = $this->db->query("SELECT * FROM `bio_device` WHERE `branch_id`='$branch' AND is_delete='0'");
        $data['biometric'] = $query->result_array();

        //calling view pages
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('biometric/biometric',$data);
    }

    public function save()
    {
        $this->user_model->check_login("admin");
        $this->load->model("user_model");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
        if($this->input->post())
            {
                $data=$this->input->post();
                $data['branch_id'] = $this->user_model->getBranch();
                $this->db->insert('bio_device',$data);
                redirect("Biometric/index","refresh"); 
            }
        else
            {
                redirect("Biometric/index","refresh"); 

            }
        
    }

    public function edit()
    {
        $this->user_model->check_login("admin");
        $this->load->model("user_model");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
        if($this->uri->segment(3))
        {
            $data['menu'] = $this->load_model->menu();
            $id = $this->uri->segment(3);
            $data['biometric']=$this->db->where('id',$id)->get('bio_device')->row();
            $data['userInfo'] = $this->userInfo;
            $data['base_url'] = base_url();
                //calling view pages
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('biometric/biometric_edit',$data);

        }
         else
         {
                redirect("biometric/index","refresh"); 
         }   
             
    }

    public function update()
    {
        $this->user_model->check_login("admin");
        $this->load->model("user_model");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
        if($this->input->post())
        {
            $data = $this->input->post();
            $this->db->where('id',$data['id'])->update('bio_device',$data);
            redirect("biometric/index","refresh");
        }
        else
        {
            redirect("biometric/index","refresh");
        }
        

   }
   public function delete()
   {
        $this->user_model->check_login("admin");
        $this->load->model("user_model");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
        if($this->uri->segment(3))
        {
            $id=$this->uri->segment(3);
            $this->db->where('id',$id)->update('bio_device',['is_delete'=>1]);
            redirect('biometric/index','refresh');
     
        }
        else
        {
            redirect('biometric/index','refresh');
            
        }
    }

    public function updateStudentAttendance()
    {
        $devices=$this->db->where('is_delete',0)->get('bio_device')->result_array();
        $pres_num = array();
        foreach ($devices as $key => $selected_device) {
            
            $params = [$selected_device['ip'] ,$selected_device['port'] ];
            $this->load->library('ZKLib/ZKLib',$params,'zk');
            $res = $this->zk->connect();
          //   var_dump('<pre>',$res);die();
            if(!$res){
                continue;
            }

            $attendance = $this->zk->getAttendance();
        
            if(!empty($attendance)){
                $last_sync = $this->db->limit(1)->where('device_id',$selected_device['id'])->get('last_sync')->row_array();
                $last_sync?$insert=false:$insert=true;
                $last_sync?$last_sync_uid=$last_sync['uid']:$last_sync_uid=0;
                foreach ($attendance as $key => $value) {
                    if($value[0]<=$last_sync_uid){
                        unset($attendance[$key]);
                    }else{
                        break;
                    }
                }
                if(count($attendance)>0){
                    foreach ($attendance as $key => $value) {
                        $pro_id = $this->db->where('is_active',1)->where('student_id',$value[1])->get('promotion')->row_array()['id'];
                        $std_data = $this->db->where('id',$value[1])->get('student')->row_array();
                        $pres_num[] = $std_data['father_contact'];
                        $res = $this->db->where('student_id',$value[1])->where('date',date( "Y-m-d",strtotime($value[3])) )->get('studentatt')->result_array();
                       if(empty($res) && !empty($pro_id) && !empty($std_data)){
                            $insert = array(
                                'student_id' => $value[1],
                                'promotion_id' => $pro_id,
                                'status_id' => 1,
                                'date' => date( "Y-m-d", strtotime( $value[3] ) )
                            );
                            $this->db->insert('studentatt',$insert);
                        }
                    }
                    $last_device_uid = end($attendance)[0];
                    if($insert)
                    $this->db->insert('last_sync',array('uid'=>$last_device_uid,'device_id'=>$selected_device['id'],'date'=>date('Y-m-d H:i:s') ));
                    else
                    $this->db->where('device_id',$selected_device['id'])->update('last_sync',array('uid'=>$last_device_uid,'date'=>date('Y-m-d H:i:s') ));
                }
                echo "Attendance sync success</br>";
            }
            $this->zk->disconnect();
            unset($this->zk);
         }
        $msg = "Dear Parents,\nYour Child has safely reached at academy \nThank you!";
        $this->hajanasms->sendManyNumber($pres_num,$msg);
    }
    
    public function updateAttendance()
    {
       // var_dump('yes');
       
        $devices=$this->db->where('is_delete',0)->where('type',1)->get('bio_device')->result_array();
      // var_dump($devices);die();
       
        foreach ($devices as $key => $selected_device) {
            
           // include "zklibrary.php";
            
            $params = [$selected_device['ip'] ,$selected_device['port'] ];
            //$this->load->library('ZKLib/ZKLib',$params,'zk');
            
           //var_dump($selected_device['ip']);
           
              $zk = new ZKLibrary($selected_device['ip'], 4371);
            $res =$zk->connect();
           // var_dump($res);
             if(!$res){
                continue;
            }
            
            
              $zk->disableDevice();
            $attendance = $zk->getAttendance();
            //var_dump($attendance);die();
            
//       var_dump('<pre>',$attendance);die();
            $users = $zk->getUser();
            $teachers = $this->getTeachers($users);
            $staff = $this->getStaff($users);
            
            
      
            if(!empty($attendance)){
                $last_sync = $this->db->limit(1)->where('device_id',$selected_device['id'])->get('last_sync')->row_array();
                $last_sync?$insert=false:$insert=true;
                $last_sync?$last_sync_uid=$last_sync['uid']:$last_sync_uid=0;
                foreach ($attendance as $key => $value) {
                    if($value[0]<=$last_sync_uid){
                        unset($attendance[$key]);
                    }else{
                        break;
                    }
                }
                        if(count($attendance)>0){
                        //checking teacher attendance
                        if(!empty($teachers)){
                        foreach ($attendance as $key => $value) {
                        $user_key=array_search($value[1],array_column($teachers,"0"));
                        if(is_numeric($user_key)){
                        $teacher_id=explode(".",$teachers[$user_key][1])[1];
                        if($teacher_id>0){
                        $marked = $this->db->where('teacher_id',$teacher_id)->where('date',date('Y-m-d',strtotime($value[3])))->get("teacherattendance")->row_array();
                        if($marked){
                            //var_dump('teacher _update');
                        $this->db->where('id',$marked['id'])->update('teacherattendance',['check_out'=>$value[3]]);
                     
                        }else{
                            //var_dump('teacher_insert');
                        $check_branch=$this->db->select('branch')
                                               ->from('teacher')
                                               ->where('id',$teacher_id)
                                               ->get()->row_array()['branch'];
                        if($check_branch==1) 
                        {
                            $att_data = array(
                            'teacher_id' => $teacher_id,
                            'date'=>date('Y-m-d',strtotime($value[3])),
                            'status_id'=>1,
                            'check_in'=>$value[3]
                            );
                        }else
                        {
                            $att_data = array(
                            'teacher_id' => $teacher_id,
                            'date'=>date('Y-m-d',strtotime($value[3])),
                            'status_id'=>3,
                            'check_in'=>$value[3]
                            );
                        }
                        
                        $this->db->insert('teacherattendance',$att_data);
                        }

                        }
                        }
                        }
                        }
                    if(!empty($staff)){
                        foreach ($attendance as $key => $value) {
                            $user_key=array_search($value[1],array_column($staff,"0"));
                            if(is_numeric($user_key)){
                                $staff_id=explode(".",$staff[$user_key][1])[1];
                                if($staff_id>0){
                                    $marked = $this->db->where('staff_id',$staff_id)->where('date',date('Y-m-d',strtotime($value[3])))->get("staffatt")->row_array();
                                         if($marked){
                            //var_dump('staff_update');
                         $this->db->where('id',$marked['id'])->update('staffatt',['check_out'=>$value[3]]);
                     
                        }else{
                            //var_dump('staff_insert');
                            $check_branch=$this->db->select('branch')
                                               ->from('staff')
                                               ->where('id',$staff_id)
                                               ->get()->row_array()['branch'];
                       if($check_branch==1)  
                       {
                            $att_data = array(
                                            'staff_id' => $staff_id,
                                            'date'=>date('Y-m-d',strtotime($value[3])),
                                            'status_id'=>1,
                                            'check_in'=>$value[3]
                                        );
                       }else
                       {
                            $att_data = array(
                                            'staff_id' => $staff_id,
                                            'date'=>date('Y-m-d',strtotime($value[3])),
                                            'status_id'=>3,
                                            'check_in'=>$value[3]
                                        );
                       }
                      
                         $this->db->insert('staffatt',$att_data);
                        }

                                }
                            }
                        }
                    }
                    $last_device_uid = end($attendance)[0];
                    if($insert)
                    $this->db->insert('last_sync',array('uid'=>$last_device_uid,'device_id'=>$selected_device['id'],'date'=>date('Y-m-d H:i:s') ));
                    else
                    $this->db->where('device_id',$selected_device['id'])->update('last_sync',array('uid'=>$last_device_uid,'date'=>date('Y-m-d H:i:s') ));
                }
                echo "Attendance sync success! You will be redirected shortly, Please wait...</br>";
            }
            
            
             $attendance = $zk->getAttendance(); 
            $data=date("Y-m-d", strtotime($attendance[0][3]));
            date_default_timezone_set("Asia/Karachi");
            $da=date("Y-m-d");
            $datetime1 = new DateTime($data);
            $datetime2 = new DateTime($da);
            $interval = $datetime1->diff($datetime2);
            $diff=$interval->format("%a");
            if(2<$diff)
            {
             $zk->clearAttendance();
            }
            
            $zk->disconnect();
            unset($zk);
         }
    }
    
    public function updateGatepass()
    {
        $devices=$this->db->where('is_delete',0)->where('type',2)->get('bio_device')->result_array();
        
        $in_num = array();
        $out_num = array();
        foreach ($devices as $key => $selected_device) {
            
            $params = [$selected_device['ip'] ,$selected_device['port'] ];
          //  $this->load->library('ZKLib/ZKLib',$params,'zk');
        //    $res = $this->zk->connect();
          //   var_dump('<pre>',$res);die();
          
            $zk = new ZKLibrary($selected_device['ip'], 4371);
            $res =$zk->connect();
            if(!$res){
                continue;
            }
            $attendance = $zk->getAttendance();
            $users = $zk->getUser();
            $teachers = $this->getTeachers($users);
            $staff = $this->getStaff($users);
            $cadets = $this->getCadets($users);
            
            if(!empty($attendance)){
                $last_sync = $this->db->limit(1)->where('device_id',$selected_device['id'])->get('last_sync')->row_array();
                $last_sync?$insert=false:$insert=true;
                $last_sync?$last_sync_uid=$last_sync['uid']:$last_sync_uid=0;
                foreach ($attendance as $key => $value) {
                    if($value[0]<=$last_sync_uid){
                        unset($attendance[$key]);
                    }else{
                        break;
                    }
                }
                if(count($attendance)>0){
                    //checking teacher attendance
                    if(!empty($teachers)){
                        foreach ($attendance as $key => $value) {
                            $user_key=array_search($value[1],array_column($teachers,"0"));
                            if(is_numeric($user_key)){
                                $teacher_id=explode(".",$teachers[$user_key][1])[1];
                                if($teacher_id>0){
                                    $exist = $this->db->where('id',$teacher_id)->where('is_delete',0)->where('status',0)->get("teacher")->row_array();
                                    if($exist){
                                        $gatepass_data = array(
                                            'bothid' => $teacher_id,
                                            'type' => "teacher",
                                            'status' => $value[2],
                                            'datetime' => $value[3]
                                        );
                                        $this->db->insert('staff_teacher_gatepass',$gatepass_data);
                                    }
                                }
                            }
                        }
                    }
                    if(!empty($staff)){
                        foreach ($attendance as $key => $value) {
                            $user_key=array_search($value[1],array_column($staff,"0"));
                            if(is_numeric($user_key)){
                                $staff_id=explode(".",$staff[$user_key][1])[1];
                                if($staff_id>0){
                                    $exist = $this->db->where('id',$staff_id)->where('is_delete',0)->where('status',0)->get("staff")->row_array();
                                    if($exist){
                                        $gatepass_data = array(
                                            'bothid' => $staff_id,
                                            'type' => "staff",
                                            'status' => $value[2],
                                            'datetime' => $value[3]
                                        );
                                        $this->db->insert('staff_teacher_gatepass',$gatepass_data);
                                    }
                                }
                            }
                        }
                    }
                    if(!empty($cadets)){
                        foreach ($attendance as $key => $value) {
                            $user_key=array_search($value[1],array_column($cadets,"0"));
                            if(is_numeric($user_key)){
                                $cadet_id=explode(".",$cadets[$user_key][1])[1];
                                if($cadet_id>0){
                                    $exist = $this->db->where('id',$cadet_id)->where('is_delete',0)->where('status',0)->get("student")->row_array();
                                    if($exist){
                                        if($value[2]==1){
                                            $in_num[] = $exist['father_contact'];
                                        }elseif($value[2]==2){
                                            $out_num[] = $exist['father_contact'];
                                        }
                                        $gatepass_data = array(
                                            'student_id' => $cadet_id,
                                            'status' => $value[2],
                                            'datetime' => $value[3]
                                        );
                                        $this->db->insert('cadet_gatepass',$gatepass_data);
                                    }
                                }
                            }
                        }
                    }
                    $msg_out = "Dear Parents,\nYour Son/Ward has departed from Cadet College Sanghar. \nThank you!";
                    $msg_in = "Dear Parents,\nYour Son/Ward has arrived at Cadet College Sanghar.\nThank you!";
                    $this->hajanasms->sendManyNumber($in_num,$msg_in);
                    $this->hajanasms->sendManyNumber($out_num,$msg_out);
                    
                    $last_device_uid = end($attendance)[0];
                    if($insert)
                    $this->db->insert('last_sync',array('uid'=>$last_device_uid,'device_id'=>$selected_device['id'],'date'=>date('Y-m-d H:i:s') ));
                    else
                    $this->db->where('device_id',$selected_device['id'])->update('last_sync',array('uid'=>$last_device_uid,'date'=>date('Y-m-d H:i:s') ));
                }
                echo "Attendance sync success! You will be redirected shortly, Please wait...</br>";
            }
            $zk->disconnect();
            unset($this->zk);
         }
    }

    public function getTeachers($users='')
    {
        if($users!=''){
            $teachers=array();
            foreach ($users as $key => $value) {
                $check = explode('.',$value[1]);
                if($check[0]=="T")
                $teachers[] = $value;
            }
            return $teachers;
        }else{
            return false;
        }
    }
    
    public function getStaff($users='')
    {
        if($users!=''){
            $teachers=array();
            foreach ($users as $key => $value) {
                $check = explode('.',$value[1]);
                if($check[0]=="S")
                $teachers[] = $value;
            }
            return $teachers;
        }else{
            return false;
        }
    }
    
    public function getCadets($users='')
    {
        if($users!=''){
            $teachers=array();
            foreach ($users as $key => $value) {
                $check = explode('.',$value[1]);
                if($check[0]=="C")
                $teachers[] = $value;
            }
            return $teachers;
        }else{
            return false;
        }
    }

    public function updateManualAttendance()
    {
        $this->updateAttendance();
        echo '<script>window.location = "'.base_url().'";</script>';
        // redirect('Home/',"refresh");
    }
    
    public function updateManualGatepass()
    {
        $this->updateGatepass();
        echo '<script>window.location = "'.base_url().'";</script>';
        // redirect('Home/',"refresh");
    }

}
